/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tesla.aether.concurrency;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonatype.aether.spi.log.Logger;

class FileUtils {
    FileUtils() {
    }

    public static boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        File canonDir = null;
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (FileUtils.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    public static RandomAccessFile open(File file, String mode) throws IOException {
        boolean interrupted = false;
        try {
            FileUtils.mkdirs(file.getParentFile());
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, mode);
            return randomAccessFile;
        }
        catch (IOException e) {
            for (int i = 3; i >= 0; --i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    interrupted = true;
                }
                try {
                    RandomAccessFile e1 = new RandomAccessFile(file, mode);
                    return e1;
                }
                catch (IOException ie) {
                    continue;
                }
            }
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void close(Closeable closeable, Logger logger) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (logger == null) break block3;
                    logger.warn("Failed to close file: " + e);
                }
            }
        }
    }
}

