/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.winsrv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.jetty.util.IO;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class WinSrvPlugin
extends JettyConsolePluginBase {
    private StartOption installWinSrv = new DefaultStartOption("installWindowsService", "serviceName", "Install a windows Service", "Windows"){

        public String validate(String serviceName) {
            try {
                File warLocation = WinSrvPlugin.this.getWarLocation();
                File wd = warLocation.getParentFile();
                File bin = new File(wd, "bin");
                bin.mkdirs();
                File logs = new File(wd, "logs");
                logs.mkdirs();
                File temp = new File(wd, "temp");
                temp.mkdirs();
                File stdOut = new File(logs, "stdout.txt");
                File stdErr = new File(logs, "stderr.txt");
                File exeFile = WinSrvPlugin.this.unpackExeFile("jettyconsole.exe", new File(bin, serviceName + ".exe"));
                WinSrvPlugin.this.unpackExeFile("jettyconsolew.exe", new File(bin, serviceName + "w.exe"));
                String[] cmd = new String[]{exeFile.getAbsolutePath(), "//IS//" + serviceName, "--Classpath=" + warLocation.getAbsolutePath(), "--Jvm=auto", "--StartMode=jvm", "--StartClass=JettyConsoleBootstrapMainClass", "--StartPath=" + wd.getAbsolutePath(), "--StartMethod=start", "--StartParams=--headless", "--StopMode=jvm", "--StopClass=JettyConsoleBootstrapMainClass", "--StopPath=" + wd.getAbsolutePath(), "--StopMethod=stop", "--LogPath=" + logs.getAbsolutePath(), "--LogLevel=INFO", "--LogPrefix=service.log", "--StdOutput=" + stdOut.getAbsolutePath(), "--StdError=" + stdErr.getAbsolutePath()};
                System.out.println("Installing Windows Service " + serviceName + "..");
                Process process = Runtime.getRuntime().exec(cmd);
                int returnValue = process.waitFor();
                if (returnValue != 0) {
                    System.out.println("Process returned " + returnValue);
                }
                System.out.println("Finished installing service " + serviceName);
                System.exit(0);
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private StartOption removeWinSrv = new DefaultStartOption("removeWindowsService", "serviceName", "Remove a windows Service", "Windows"){

        public String validate(String serviceName) {
            try {
                File warLocation = WinSrvPlugin.this.getWarLocation();
                File wd = warLocation.getParentFile();
                File bin = new File(wd, "bin");
                bin.mkdirs();
                File exeFile = WinSrvPlugin.this.unpackExeFile("jettyconsole.exe", new File(bin, serviceName + ".exe"));
                String[] cmd = new String[]{exeFile.getAbsolutePath(), "//DS//" + serviceName};
                System.out.println("Removing Windows Service " + serviceName);
                Process process = Runtime.getRuntime().exec(cmd);
                process.waitFor();
                System.out.println("Finished removing service " + serviceName);
                System.exit(0);
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public WinSrvPlugin() {
        super(WinSrvPlugin.class);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            this.addStartOptions(new StartOption[]{this.installWinSrv, this.removeWinSrv});
        }
    }

    public File getWarLocation() {
        URL resource = WinSrvPlugin.class.getResource("/WEB-INF/web.xml");
        String file = resource.getFile();
        file = file.substring("file:".length(), file.indexOf("!"));
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new File(file);
    }

    private File unpackExeFile(String resourceName, File file) throws IOException {
        System.out.println("Install service");
        URL resource = ((Object)((Object)this)).getClass().getResource(resourceName);
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = resource.openStream();
        IO.copy((InputStream)in, (OutputStream)out);
        out.close();
        in.close();
        return file;
    }
}

