package org.simplericity.jettyconsole.jettyxml;

import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;

public class JettySecurityPlugin extends JettyConsolePluginBase {

    public JettySecurityPlugin() {
        super(JettySecurityPlugin.class);
    }

    @Override
    public void beforeStart(WebAppContext context) {        
        SecurityHandler sh = new ConstraintSecurityHandler();
        LoginService loginService = new HashLoginService( "Default Name" );
        sh.setLoginService( loginService );        
        context.setSecurityHandler( sh );
    }
}
