/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.requestlog;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class RequestLogPlugin
extends JettyConsolePluginBase {
    private File logFile;
    private StartOption requestLogOption = new DefaultStartOption("requestLog", "logFile", "Log requests to file", "Request logging"){

        public String validate(String value) {
            RequestLogPlugin.this.logFile = new File(value);
            if (RequestLogPlugin.this.logFile.getParentFile() != null && !RequestLogPlugin.this.logFile.getParentFile().exists()) {
                return "Directory does not exist: " + RequestLogPlugin.this.logFile.getParentFile().getPath();
            }
            return null;
        }
    };
    private boolean extended;
    private StartOption requestLogExtended = new DefaultStartOption("requestLogExtended", "Use extended log format with referrer and user-agent", "Request logging"){

        public String validate() {
            RequestLogPlugin.this.extended = true;
            return null;
        }
    };

    public RequestLogPlugin() {
        super(RequestLogPlugin.class);
        this.addStartOptions(new StartOption[]{this.requestLogOption, this.requestLogExtended});
    }

    public void customizeServer(Server server) {
        if (this.logFile != null) {
            HandlerCollection rootHandler = (HandlerCollection)server.getHandler();
            ArrayList<Object> handlers = new ArrayList<Object>();
            handlers.addAll(Arrays.asList(rootHandler.getHandlers()));
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            NCSARequestLog requestLog = new NCSARequestLog(this.logFile.getAbsolutePath());
            requestLog.setRetainDays(0);
            requestLog.setAppend(true);
            requestLog.setExtended(this.extended);
            requestLog.setLogTimeZone("GMT");
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            handlers.add(requestLogHandler);
            rootHandler.setHandlers(handlers.toArray(new Handler[handlers.size()]));
        }
    }
}

