/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.nexus;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;

public class NexusPlugin
extends JettyConsolePluginBase {
    private String[] resources = new String[]{"broker.groovy", "capabilities.xml", "logback-events.xml", "logback-healthcheck.xml", "logback-nexus.xml", "logback-smartproxy.xml", "logback.properties", "logback.xml", "lvo-plugin.xml", "nexus.xml", "pgp.xml", "procurement.xml", "security-configuration.xml", "security.xml", "staging.xml"};

    public NexusPlugin() {
        super(NexusPlugin.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void bootstrap() {
        File nexusWork = new File(new File(System.getProperty("user.home"), "sonatype-trial"), "nexus");
        File nexusConf = new File(nexusWork, "conf");
        if (!nexusWork.exists()) {
            System.out.println("Initializing Nexus Professional Trial Configuration!");
            for (String resource : this.resources) {
                InputStream is = NexusPlugin.class.getClassLoader().getResourceAsStream("nexus/conf/" + resource);
                FileOutputStream os = null;
                if (is == null) continue;
                try {
                    File f = new File(nexusConf, resource);
                    if (!f.getParentFile().exists()) {
                        f.getParentFile().mkdirs();
                    }
                    os = new FileOutputStream(f);
                    NexusPlugin.copy(is, os);
                }
                catch (FileNotFoundException e) {
                    NexusPlugin.closeQuietly(is);
                    NexusPlugin.closeQuietly(os);
                    continue;
                }
                catch (IOException e2) {
                    NexusPlugin.closeQuietly(is);
                    NexusPlugin.closeQuietly(os);
                    continue;
                    {
                        catch (Throwable throwable) {
                            NexusPlugin.closeQuietly(is);
                            NexusPlugin.closeQuietly(os);
                            throw throwable;
                        }
                    }
                }
                NexusPlugin.closeQuietly(is);
                NexusPlugin.closeQuietly(os);
            }
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8024];
        int n = 0;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

