package org.simplericity.jettyconsole.nexus;

import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.xml.sax.SAXException;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ArrayList;

public class NexusPlugin extends JettyConsolePluginBase {

  private String[] resources = new String[] {
    "broker.groovy",
    "capabilities.xml",
    "logback-events.xml",
    "logback-healthcheck.xml",
    "logback-nexus.xml",
    "logback-smartproxy.xml",
    "logback.properties",
    "logback.xml",
    "lvo-plugin.xml",
    "nexus.xml",
    "pgp.xml",
    "procurement.xml",
    "security-configuration.xml",
    "security.xml",
    "staging.xml"   
  };
  
  public NexusPlugin() {
    super(NexusPlugin.class);
  }
   
  @Override
  public void bootstrap() {
    File nexusWork = new File(new File(System.getProperty("user.home"), "sonatype-trial"), "nexus");
    File nexusConf = new File(nexusWork, "conf");
    
    if (nexusWork.exists() == false) {
      
      System.out.println("Initializing Nexus Professional Trial Configuration!");
      //
      // We will assume they are starting up the WAR for the first time and we want to make
      // sure the configuration for the Nexus Pro Trial is in place.
      //
      for(String resource : resources) {
        InputStream is = NexusPlugin.class.getClassLoader().getResourceAsStream("nexus/conf/" + resource);
        OutputStream os = null;        
        if(is != null) {
          try {
            File f = new File(nexusConf, resource);
            if(f.getParentFile().exists()==false) {
              f.getParentFile().mkdirs();
            }
            os = new FileOutputStream(f);
            copy(is,os);
          } catch (FileNotFoundException e) {
          } catch (IOException e) {
          } finally {
            closeQuietly(is);
            closeQuietly(os);
          }
        }
      }
    }
  }
  
  public static long copy(final InputStream input, final OutputStream output) throws IOException {
    final byte[] buffer = new byte[8024];
    int n = 0;
    long count = 0;
    while (-1 != (n = input.read(buffer))) {
      output.write(buffer, 0, n);
      count += n;
    }
    return count;
  }
  
  public static void closeQuietly(InputStream input) {
    try {
      if (input != null) {
        input.close();
      }
    } catch (IOException ioe) {
      // ignore
    }
  }

  public static void closeQuietly(OutputStream output) {
    try {
      if (output != null) {
        output.close();
      }
    } catch (IOException ioe) {
      // ignore
    }
  }  
}
