/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.jettyxml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;
import org.xml.sax.SAXException;

public class JettyXmlPlugin
extends JettyConsolePluginBase {
    private List<File> jettyXmlFiles = new ArrayList<File>();
    private List<File> jettyWebXmlFiles = new ArrayList<File>();
    private StartOption jettyXmlOption = new JettyXmlFileOption("jettyXml", "file", "Apply server configuration from a Jetty XML file", "Options", this.jettyXmlFiles);
    private StartOption jettyWebXmlOption = new JettyXmlFileOption("jettyWebXml", "file", "Apply webapp context configuration from a Jetty Web XML file", "Options", this.jettyWebXmlFiles);

    public JettyXmlPlugin() {
        super(JettyXmlPlugin.class);
        this.addStartOptions(new StartOption[]{this.jettyXmlOption, this.jettyWebXmlOption});
    }

    public void customizeServer(Server server) {
        for (File file : this.jettyXmlFiles) {
            this.configure(server, file);
        }
    }

    public void beforeStart(WebAppContext context) {
        for (File file : this.jettyWebXmlFiles) {
            this.configure(context, file);
        }
    }

    private void configure(Object object, File file) {
        try {
            XmlConfiguration configuration = new XmlConfiguration(file.toURL());
            configuration.configure(object);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JettyXmlFileOption
    extends DefaultStartOption {
        private final List<File> fileList;

        JettyXmlFileOption(String name, String valueSample, String description, String section, List<File> fileList) {
            super(name, valueSample, description, section);
            this.fileList = fileList;
        }

        public String validate(String value) {
            File file = new File(value);
            if (!file.exists()) {
                return "Jetty XML file " + file.toString() + " does not exist";
            }
            this.fileList.add(file);
            return null;
        }
    }
}

