/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.plugins;

import java.io.File;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.Settings;
import org.simplericity.jettyconsole.api.StartOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmpDirPlugin
extends JettyConsolePluginBase {
    private Settings settings;
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private File tmpDir;
    private StartOption tmpDirOption = new DefaultStartOption("tmpDir", "/path", "Temporary directory, default is " + System.getProperty("java.io.tmpdir"), "Options"){

        public String validate(String value) {
            TmpDirPlugin.this.tmpDir = new File(value);
            if (!TmpDirPlugin.this.tmpDir.exists()) {
                return "tmpDir does not exist: " + value;
            }
            if (!TmpDirPlugin.this.tmpDir.isDirectory()) {
                return "tmpDir is not a directory: " + value;
            }
            return null;
        }
    };

    public TmpDirPlugin(Settings settings) {
        super(TmpDirPlugin.class);
        this.settings = settings;
        this.addStartOptions(new StartOption[]{this.tmpDirOption});
    }
}

