/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.plugins;

import org.eclipse.jetty.webapp.WebAppContext;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class DirAllowedPlugin
extends JettyConsolePluginBase {
    private boolean dirAllowed = false;
    private StartOption dirAllowedOption = new DefaultStartOption("dirAllowed", "true|false", "Allow directory indexes? (Default: false)", "Options"){

        public String validate(String value) {
            if (!"true".equals(value) && !"false".equals(value)) {
                return "dirAllowed option must be 'true' or 'false'";
            }
            DirAllowedPlugin.this.dirAllowed = "true".equals(value);
            return null;
        }
    };

    public DirAllowedPlugin() {
        super(DirAllowedPlugin.class);
        this.addStartOptions(new StartOption[]{this.dirAllowedOption});
    }

    public void beforeStart(WebAppContext context) {
        context.getInitParams().put("org.eclipse.jetty.servlet.Default.dirAllowed", Boolean.toString(this.dirAllowed));
    }
}

