/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.kantega.jexmec.PluginLoader;
import org.kantega.jexmec.PluginManager;
import org.kantega.jexmec.ServiceKey;
import org.kantega.jexmec.ctor.ConstructorInjectionPluginLoader;
import org.kantega.jexmec.manager.DefaultPluginManager;
import org.simplericity.jettyconsole.DefaultConfiguration;
import org.simplericity.jettyconsole.DefaultJettyManager;
import org.simplericity.jettyconsole.JettyConsole;
import org.simplericity.jettyconsole.JettyManager;
import org.simplericity.jettyconsole.api.Configuration;
import org.simplericity.jettyconsole.api.JettyConsolePlugin;
import org.simplericity.jettyconsole.api.Settings;
import org.simplericity.jettyconsole.api.StartOption;
import org.simplericity.jettyconsole.io.MultiOutputStream;
import org.simplericity.macify.eawt.ApplicationAdapter;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyConsoleStarter
extends ApplicationAdapter {
    private JettyConsole console;
    private DefaultPluginManager<JettyConsolePlugin> pluginManager;
    private PrintStream origOut = System.out;
    private PrintStream origErr = System.err;
    private MultiOutputStream multiErr;
    private MultiOutputStream multiOut;
    private static JettyConsoleStarter starter;
    private JettyManager jettyManager;

    public static void main(String[] args) throws Exception {
        starter = new JettyConsoleStarter();
        ShutdownThread.register((LifeCycle[])new LifeCycle[0]);
        starter.startPluginManager();
        if (starter.isHelpRequested(args)) {
            starter.usage();
        }
        starter.run(starter.readConfiguration(args));
    }

    public static void stop() {
        starter.shutdown();
    }

    private void shutdown() {
        if (this.jettyManager != null) {
            this.jettyManager.shutdown();
        }
    }

    private void startPluginManager() {
        this.pluginManager = this.createPluginManager(this.getSettings());
        this.pluginManager.start();
    }

    private Configuration readConfiguration(String[] args) {
        return this.parseCommandLine(args, new DefaultConfiguration());
    }

    private Configuration parseCommandLine(String[] args, Configuration configuration) {
        Map<String, StartOption> pluginOptions = this.createOptionByNameMap();
        for (int i = 0; i < args.length; ++i) {
            StartOption option;
            String arg = args[i].trim();
            if (!arg.startsWith("--")) {
                this.usage("Options must start with '--': " + args);
            }
            if ((option = pluginOptions.get((arg = arg.substring(2)).toLowerCase())) == null) {
                this.usage("Unknown option: '" + arg + "'");
            }
            if (option.getValueSample() != null) {
                String errorMessage;
                if (i == args.length - 1) {
                    this.usage(option.getRequiredValueMissingMessage());
                    continue;
                }
                if ((errorMessage = option.validate(args[++i].trim())) == null) continue;
                this.usage(errorMessage);
                continue;
            }
            option.validate();
        }
        return configuration;
    }

    private Map<String, StartOption> createOptionByNameMap() {
        HashMap<String, StartOption> options = new HashMap<String, StartOption>();
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            for (StartOption option : plugin.getStartOptions()) {
                options.put(option.getName().toLowerCase(), option);
            }
        }
        return options;
    }

    private void usage() {
        this.usage(null);
    }

    private void usage(String args) {
        PrintStream err = System.err;
        if (args != null) {
            err.println("ERROR: " + args);
            err.println();
        }
        err.println("Usage: java " + JettyConsoleStarter.class.getName() + " [--option value] [--option2 value2] [--option3]");
        err.println();
        Map<String, List<StartOption>> options = this.createOptionsBySectionMap((PluginManager<JettyConsolePlugin>)this.pluginManager);
        TreeSet<String> sortedSections = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s, String s1) {
                if (s.equals("Options")) {
                    return -1;
                }
                if (s1.equals("Options")) {
                    return 1;
                }
                return s.compareTo(s1);
            }
        });
        sortedSections.addAll(options.keySet());
        for (String section : sortedSections) {
            err.println(section + ":");
            for (StartOption option : options.get(section)) {
                StringBuilder line = new StringBuilder(" --" + option.getName() + " ");
                if (option.getValueSample() != null) {
                    line.append(option.getValueSample()).append(" ");
                }
                while (line.length() < 21) {
                    line.append(" ");
                }
                line.append("- ").append(option.getDescription());
                err.println(line);
            }
            err.println();
        }
        System.exit(1);
    }

    private Map<String, List<StartOption>> createOptionsBySectionMap(PluginManager<JettyConsolePlugin> pluginManager) {
        TreeMap<String, List<StartOption>> map = new TreeMap<String, List<StartOption>>();
        for (JettyConsolePlugin plugin : pluginManager.getPlugins()) {
            for (StartOption option : plugin.getStartOptions()) {
                if (!map.containsKey(option.getSection())) {
                    map.put(option.getSection(), new ArrayList());
                }
                ((List)map.get(option.getSection())).add(option);
            }
        }
        return map;
    }

    private boolean isHelpRequested(String[] args) {
        for (String arg : args) {
            if (!"--help".equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    private void run(Configuration configuration) throws Exception {
        this.setupStreams();
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            plugin.configureConsole(configuration);
        }
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            plugin.bootstrap();
        }
        this.jettyManager = new DefaultJettyManager(this.getSettings(), (PluginManager<JettyConsolePlugin>)this.pluginManager);
        if (configuration.isHeadless() || GraphicsEnvironment.isHeadless()) {
            this.initConsoleApp(configuration, this.jettyManager);
        } else {
            this.initSwingApp(configuration, this.jettyManager);
        }
    }

    private DefaultPluginManager createPluginManager(Properties settings) {
        DefaultPluginManager manager = new DefaultPluginManager(JettyConsolePlugin.class);
        manager.addPluginClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        manager.addPluginLoader((PluginLoader)new ConstructorInjectionPluginLoader());
        manager.addService(ServiceKey.by(Settings.class), (Object)new DefaultSettings(settings));
        return manager;
    }

    private void initConsoleApp(Configuration configuration, JettyManager jettyManager) {
        jettyManager.startServer(configuration);
    }

    private void initSwingApp(final Configuration configuration, final JettyManager jettyManager) throws Exception {
        final Properties settings = this.getSettings();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JettyConsoleStarter.this.console = new JettyConsole(settings, jettyManager, (PluginManager<JettyConsolePlugin>)JettyConsoleStarter.this.pluginManager);
                JettyConsoleStarter.this.console.setMultiOut(JettyConsoleStarter.this.multiOut);
                JettyConsoleStarter.this.console.setMultiErr(JettyConsoleStarter.this.multiErr);
                try {
                    JettyConsoleStarter.this.console.init(configuration);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.initAppleExtensions(settings);
    }

    private void setupStreams() {
        this.multiOut = new MultiOutputStream(this.origOut);
        System.setOut(new PrintStream(this.multiOut, true));
        this.multiErr = new MultiOutputStream(this.origErr);
        System.setErr(new PrintStream(this.multiErr, true));
    }

    private void initAppleExtensions(Properties settings) throws Exception {
        DefaultApplication application = new DefaultApplication();
        if (application.isMac()) {
            application.addApplicationListener((ApplicationListener)this);
            InputStream imageStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/background-image.jpg");
            if (imageStream != null) {
                BufferedImage image = ImageIO.read(imageStream);
                BufferedImage icon = new BufferedImage(128, 128, 2);
                float imageRatio = (float)image.getWidth() / (float)image.getHeight();
                int width = imageRatio > 1.0f ? (int)((float)icon.getWidth() * imageRatio) : icon.getWidth();
                int height = imageRatio < 1.0f ? (int)((float)icon.getHeight() / imageRatio) : icon.getHeight();
                int x = icon.getWidth() / 2 - width / 2;
                int y = icon.getHeight() / 2 - height / 2;
                Graphics2D g2 = (Graphics2D)icon.getGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                RoundRectangle2D.Double rect = new RoundRectangle2D.Double(1.0, 1.0, 126.0, 126.0, 50.0, 50.0);
                g2.setClip(rect);
                g2.drawImage(image, x, y, width, height, null);
                g2.setClip(0, 0, icon.getWidth(), icon.getHeight());
                g2.setColor(Color.DARK_GRAY);
                g2.draw(rect);
                g2.dispose();
                icon.flush();
                application.setApplicationIconImage(icon);
            }
        }
    }

    public void handleQuit(ApplicationEvent event) {
        this.console.conditionalExit();
    }

    public Properties getSettings() {
        try {
            Properties settings = new Properties();
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/jettyconsole/jettyconsole.properties");
            if (is != null) {
                settings.load(is);
            }
            return settings;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultSettings
    implements Settings {
        private Properties properties;

        DefaultSettings(Properties properties) {
            this.properties = properties;
        }

        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public Collection<String> getPropertyNames() {
            return new HashSet<Object>(this.properties.keySet());
        }
    }
}

