/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class JettyConsoleBootstrapMainClass
implements Runnable {
    private static JettyConsoleBootstrapMainClass instance;
    private ClassLoader cl;
    private Runnable shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String[] arguments) throws Exception {
        System.out.println("JettyConsole Windows Service starting");
        instance = new JettyConsoleBootstrapMainClass();
        instance.setupWindowsService();
        instance.run(arguments);
        JettyConsoleBootstrapMainClass jettyConsoleBootstrapMainClass = instance;
        synchronized (jettyConsoleBootstrapMainClass) {
            instance.wait();
        }
        JettyConsoleBootstrapMainClass.instance.shutdown.run();
        System.out.println("JettyConsole Windows Service main thread exiting");
    }

    private void setupWindowsService() {
        File tempDirectory = new File(".", "temp");
        System.setProperty("java.io.tmpdir", tempDirectory.getAbsolutePath());
        tempDirectory.mkdirs();
        for (File child : tempDirectory.listFiles()) {
            this.delete(child);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String[] args) {
        System.out.println("JettyConsole Windows Service stopping");
        JettyConsoleBootstrapMainClass jettyConsoleBootstrapMainClass = instance;
        synchronized (jettyConsoleBootstrapMainClass) {
            instance.notifyAll();
        }
    }

    public static void main(String[] arguments) throws Exception {
        new JettyConsoleBootstrapMainClass().run(arguments);
    }

    private void run(String[] arguments) throws Exception {
        this.checkTemporaryDirectory(arguments);
        this.addShutdownHook();
        File war = this.getWarLocation();
        this.cl = this.createClassLoader(war);
        Thread.currentThread().setContextClassLoader(this.cl);
        this.startJettyConsole(this.cl, arguments);
    }

    private void checkTemporaryDirectory(String[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (!"--tmpDir".equals(argument)) continue;
            if (i == arguments.length - 1) {
                System.err.println("--tmpDir must take a path as an argument");
                continue;
            }
            File tmpDir = new File(arguments[i + 1]);
            if (!tmpDir.exists()) {
                this.err("tmpDir does not exist: " + tmpDir);
                continue;
            }
            if (!tmpDir.isDirectory()) {
                this.err("tmpDir is not a directory: " + tmpDir);
                continue;
            }
            System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
        }
    }

    private void err(String msg) {
        System.err.println();
        System.err.println("ERROR: " + msg);
        System.exit(0);
    }

    private void startJettyConsole(ClassLoader cl, String[] arguments) {
        try {
            Class<?> starterClass = cl.loadClass("org.simplericity.jettyconsole.JettyConsoleStarter");
            Method main = starterClass.getMethod("main", arguments.getClass());
            main.invoke(null, new Object[]{arguments});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void stopJettyConsole(ClassLoader cl) {
        try {
            Class<?> starterClass = cl.loadClass("org.simplericity.jettyconsole.JettyConsoleStarter");
            Method main = starterClass.getMethod("stop", new Class[0]);
            main.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader createClassLoader(File warFile) {
        try {
            JarEntry entry;
            ArrayList<URL> urls = new ArrayList<URL>();
            URL mainResource = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
            JarInputStream in = new JarInputStream(new FileInputStream(warFile));
            while ((entry = in.getNextJarEntry()) != null) {
                int slash;
                String name = entry.getName();
                String prefix = "META-INF/jettyconsole/lib/";
                if (!entry.isDirectory() || !name.startsWith(prefix) || (slash = name.indexOf("/", prefix.length())) <= 0) continue;
                String simpleName = name.substring(prefix.length(), slash);
                if (!name.equals(prefix + simpleName + "/")) continue;
                urls.add(new URL(mainResource, name));
            }
            in.close();
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), JettyConsoleBootstrapMainClass.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook() {
        this.shutdown = this;
        Runtime.getRuntime().addShutdownHook(new Thread(this.shutdown));
    }

    public void run() {
        this.stopJettyConsole(this.cl);
    }

    public File getWarLocation() {
        URL resource = JettyConsoleBootstrapMainClass.class.getResource("/WEB-INF/web.xml");
        String file = resource.getFile();
        file = file.substring("file:".length(), file.indexOf("!"));
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new File(file);
    }
}

