package org.simplericity.jettyconsole.plugins;

import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.eclipse.jetty.server.nio.SelectChannelConnector;

/**
 */
public class ConnectorConfigurationPlugin extends JettyConsolePluginBase {

    private int port = 8080;
    private String bindAddress = null;
    private boolean forwarded = false;

    private StartOption portOption = new DefaultStartOption("port", "n", "Create an HTTP listener on port n (default 8080)", "Options") {
        @Override
        public String validate(String value) {
            final String msg = "--port option requires a numerical value between 1 and 65535";
            try {
                int port = Integer.parseInt(value);
                if(port < 1 || port > 65535) {
                    return msg;
                }
                ConnectorConfigurationPlugin.this.port = port;

            } catch (NumberFormatException e) {
                return msg;
            }
            return null;
        }
    };

    private StartOption bindAddressOption = new DefaultStartOption("bindAddress", "addr", "Accept connections only on address addr (default: accept on any address)", "Options") {
        @Override
        public String validate(String value) {
            bindAddress = value;
            return null;
        }
    };

    private StartOption forwardedOption = new DefaultStartOption("forwarded", "Set reverse proxy handling using X-Forwarded-For headers", "Options") {
        @Override
        public String validate() {
            forwarded = true;
            return null;
        }
    };

    public ConnectorConfigurationPlugin() {
        super(ConnectorConfigurationPlugin.class);
        addStartOptions(portOption, bindAddressOption, forwardedOption);
    }

    @Override
    public void customizeConnector(SelectChannelConnector connector) {
        connector.setPort(port);
        if(bindAddress != null) {
            connector.setHost(bindAddress);
        }
        if(forwarded) {
            connector.setForwarded(true);
        }
    }
}
