/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.plugins;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.webapp.WebAppContext;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class InitParamConfigurationPlugin
extends JettyConsolePluginBase {
    private Map<String, String> initParams = new HashMap<String, String>();
    private StartOption initParamOption = new DefaultStartOption("initParam", "name=value", "Set context init parameter", "Options"){

        public String validate(String value) {
            if (!value.contains("=")) {
                return "--initParam must be specified as 'name=value'";
            }
            String name = value.substring(0, value.indexOf("="));
            String val = value.substring(value.indexOf("=") + 1);
            if (InitParamConfigurationPlugin.this.initParams.containsKey(name)) {
                return "--initParam " + name + " already specified as " + (String)InitParamConfigurationPlugin.this.initParams.get(name);
            }
            InitParamConfigurationPlugin.this.initParams.put(name, val);
            return null;
        }
    };

    public InitParamConfigurationPlugin() {
        super(InitParamConfigurationPlugin.class);
        this.addStartOptions(new StartOption[]{this.initParamOption});
    }

    public void beforeStart(WebAppContext context) {
        context.getInitParams().putAll(this.initParams);
    }
}

