/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.plugins;

import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class ConnectorConfigurationPlugin
extends JettyConsolePluginBase {
    private int port = 8080;
    private String bindAddress = null;
    private boolean forwarded = false;
    private StartOption portOption = new DefaultStartOption("port", "n", "Create an HTTP listener on port n (default 8080)", "Options"){

        public String validate(String value) {
            String msg = "--port option requires a numerical value between 1 and 65535";
            try {
                int port = Integer.parseInt(value);
                if (port < 1 || port > 65535) {
                    return "--port option requires a numerical value between 1 and 65535";
                }
                ConnectorConfigurationPlugin.this.port = port;
            }
            catch (NumberFormatException e) {
                return "--port option requires a numerical value between 1 and 65535";
            }
            return null;
        }
    };
    private StartOption bindAddressOption = new DefaultStartOption("bindAddress", "addr", "Accept connections only on address addr (default: accept on any address)", "Options"){

        public String validate(String value) {
            ConnectorConfigurationPlugin.this.bindAddress = value;
            return null;
        }
    };
    private StartOption forwardedOption = new DefaultStartOption("forwarded", "Set reverse proxy handling using X-Forwarded-For headers", "Options"){

        public String validate() {
            ConnectorConfigurationPlugin.this.forwarded = true;
            return null;
        }
    };

    public ConnectorConfigurationPlugin() {
        super(ConnectorConfigurationPlugin.class);
        this.addStartOptions(new StartOption[]{this.portOption, this.bindAddressOption, this.forwardedOption});
    }

    public void customizeConnector(SelectChannelConnector connector) {
        connector.setPort(this.port);
        if (this.bindAddress != null) {
            connector.setHost(this.bindAddress);
        }
        if (this.forwarded) {
            connector.setForwarded(true);
        }
    }
}

