/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.kantega.jexmec.PluginManager;
import org.simplericity.jettyconsole.JettyManager;
import org.simplericity.jettyconsole.api.Configuration;
import org.simplericity.jettyconsole.api.JettyConsolePlugin;
import org.simplericity.jettyconsole.api.StartOption;
import org.simplericity.jettyconsole.io.JTextAreaOutputStream;
import org.simplericity.jettyconsole.io.MultiOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyConsole {
    private AbstractAction stopAction;
    private AbstractAction startAction;
    private JScrollPane scroll;
    private MultiOutputStream multiOut;
    private MultiOutputStream multiErr;
    private JButton startStop;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private JFrame frame;
    private String name;
    private final Properties settings;
    private final JettyManager jettyManager;
    private final PluginManager<JettyConsolePlugin> pluginManager;

    public JettyConsole(Properties settings, JettyManager jettyManager, PluginManager<JettyConsolePlugin> pluginManager) {
        this.settings = settings;
        this.jettyManager = jettyManager;
        this.pluginManager = pluginManager;
    }

    public void init(final Configuration configuration) throws Exception {
        this.name = this.settings.getProperty("name");
        this.name = this.name == null ? "Jetty console" : this.name;
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", this.name);
        System.setProperty("derby.stream.error.field", "java.lang.System.out");
        this.frame = new JFrame(this.name);
        InputStream imageStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/background-image.jpg");
        final BufferedImage image = ImageIO.read(imageStream);
        JPanel back = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(image, 0, 0, null);
            }

            public Dimension getPreferredSize() {
                return new Dimension(image.getWidth(), image.getHeight());
            }
        };
        back.setOpaque(false);
        back.setLayout(new BorderLayout());
        JPanel controls = new JPanel(){

            protected void paintComponent(Graphics graphics) {
                Graphics2D g2 = (Graphics2D)graphics;
                Composite comp = g2.getComposite();
                Color c = g2.getColor();
                g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                g2.setColor(Color.WHITE);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setComposite(comp);
                g2.setColor(c);
            }
        };
        controls.setOpaque(false);
        final JTextArea text = new JTextArea(10, 7){

            protected void paintComponent(Graphics graphics) {
                Graphics2D g2 = (Graphics2D)graphics;
                Composite comp = g2.getComposite();
                Color c = g2.getColor();
                g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                g2.setColor(Color.BLACK);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2.setComposite(comp);
                g2.setColor(c);
                super.paintComponent(graphics);
            }
        };
        JTextAreaOutputStream os = new JTextAreaOutputStream(text);
        this.multiErr.addOutputStream(os);
        this.multiOut.addOutputStream(os);
        text.setMargin(new Insets(3, 3, 3, 3));
        text.setEditable(false);
        text.setOpaque(false);
        text.setWrapStyleWord(true);
        text.setForeground(Color.WHITE);
        text.setFont(text.getFont().deriveFont(11.0f));
        this.scroll = new JScrollPane(text);
        this.scroll.setOpaque(false);
        this.scroll.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        Box b = Box.createVerticalBox();
        b.add(this.scroll);
        this.scroll.getViewport().setOpaque(false);
        Component corner = this.scroll.getCorner("LOWER_RIGHT_CORNER");
        if (corner != null) {
            // empty if block
        }
        b.add(controls);
        back.add((Component)b, "South");
        final JTextField portField = new JTextField();
        portField.setText("8080");
        portField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JettyConsole.this.startAction.isEnabled()) {
                    JettyConsole.this.startAction.actionPerformed(actionEvent);
                }
            }
        });
        this.startAction = new AbstractAction("Start"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                final int port = Integer.parseInt(portField.getText());
                ServerSocket socket = null;
                try {
                    socket = new ServerSocket(port);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Port " + port + " is already in use. Please select another port.");
                    return;
                }
                finally {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                for (JettyConsolePlugin plugin : JettyConsole.this.pluginManager.getPlugins()) {
                    for (StartOption option : plugin.getStartOptions()) {
                        String error;
                        if (!"port".equals(option.getName()) || (error = option.validate(portField.getText())) == null) continue;
                        JOptionPane.showMessageDialog(null, error);
                        return;
                    }
                }
                JettyConsole.this.frame.setCursor(new Cursor(3));
                text.setText("");
                JettyConsole.this.scroll.setVisible(true);
                JettyConsole.this.scroll.invalidate();
                JettyConsole.this.scroll.doLayout();
                JettyConsole.this.scroll.paintImmediately(new Rectangle(JettyConsole.this.scroll.getSize()));
                JettyConsole.this.startAction.setEnabled(false);
                portField.setEnabled(false);
                new Thread(){

                    public void run() {
                        try {
                            JettyConsole.this.jettyManager.startServer(configuration);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JettyConsole.this.stopAction.setEnabled(true);
                                    JettyConsole.this.startStop.setAction(JettyConsole.this.stopAction);
                                }
                            });
                            JettyConsole.this.openUrl("http://localhost:" + port + configuration.getContextPath());
                        }
                        catch (Exception e) {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JettyConsole.this.startAction.setEnabled(true);
                                        JettyConsole.this.startAction.setEnabled(false);
                                    }
                                });
                                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        JettyConsole.this.frame.setCursor(new Cursor(0));
                                    }
                                });
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }.start();
            }
        };
        this.startStop = new JButton(this.startAction){};
        this.startStop.setOpaque(false);
        this.stopAction = new AbstractAction("Stop"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JettyConsole.this.stopAction.setEnabled(false);
                    JettyConsole.this.jettyManager.stopServer();
                    portField.setEnabled(true);
                    JettyConsole.this.startAction.setEnabled(true);
                    JettyConsole.this.startStop.setAction(JettyConsole.this.startAction);
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        };
        this.jettyManager.addListener(new JettyManager.JettyListener(){

            public void serverStopped() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JettyConsole.this.stopAction.setEnabled(false);
                        portField.setEnabled(true);
                        JettyConsole.this.startAction.setEnabled(true);
                        JettyConsole.this.startStop.setAction(JettyConsole.this.startAction);
                    }
                });
            }
        });
        JButton exit = new JButton(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent actionEvent) {
                JettyConsole.this.conditionalExit();
            }
        });
        exit.setOpaque(false);
        this.stopAction.setEnabled(false);
        controls.add(new JLabel("Port: "));
        controls.add(portField);
        controls.add(this.startStop);
        controls.add(exit);
        this.frame.getContentPane().add(back);
        this.frame.pack();
        text.setMaximumSize(new Dimension(text.getWidth(), 70));
        this.scroll.setMaximumSize(new Dimension(text.getWidth(), 70));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((int)screenSize.getWidth() / 2 - this.frame.getWidth() / 2, (int)screenSize.getHeight() / 2 - this.frame.getHeight() / 2);
        this.frame.setVisible(true);
        this.scroll.setVisible(false);
        this.frame.setResizable(false);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JettyConsole.this.conditionalExit();
            }
        });
        portField.setFocusable(true);
        portField.requestFocus(true);
        portField.setCaretPosition(portField.getText().length());
    }

    private void exit() {
        if (this.jettyManager != null) {
            try {
                this.jettyManager.stopServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.frame.dispose();
        System.exit(0);
    }

    private void openUrl(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, e.getMessage());
        }
    }

    public void setMultiOut(MultiOutputStream multiOut) {
        this.multiOut = multiOut;
    }

    public void setMultiErr(MultiOutputStream multiErr) {
        this.multiErr = multiErr;
    }

    public void conditionalExit() {
        if (JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to exit from " + this.name + "?", "", 0) == 0) {
            this.exit();
        }
    }
}

