/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.kantega.jexmec.PluginManager;
import org.simplericity.jettyconsole.JettyConsoleStarter;
import org.simplericity.jettyconsole.JettyManager;
import org.simplericity.jettyconsole.api.Configuration;
import org.simplericity.jettyconsole.api.JettyConsolePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJettyManager
implements JettyManager {
    private Server server;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Properties settings;
    private String name;
    private Runnable shutdownHook;
    private List<JettyManager.JettyListener> listenerList = new ArrayList<JettyManager.JettyListener>();
    private PluginManager<JettyConsolePlugin> pluginManager;
    private WebAppContext webapp;

    public DefaultJettyManager(Properties settings, PluginManager<JettyConsolePlugin> pluginManager) {
        this.settings = settings;
        this.pluginManager = pluginManager;
        this.name = this.settings.getProperty("name");
        this.shutdownHook = new Runnable(){

            public void run() {
                DefaultJettyManager.this.shutdown();
            }
        };
    }

    @Override
    public void shutdown() {
        this.log.info("Shutting down " + this.name + "..");
        try {
            if (this.server != null && (this.server.isStarted() || this.server.isStarting())) {
                this.server.stop();
                this.log.info("Shutdown of " + this.name + " complete.");
                for (JettyManager.JettyListener listener : this.listenerList) {
                    listener.serverStopped();
                }
            }
        }
        catch (Exception e) {
            this.log.info("Exception shutting down " + this.name + ": " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startServer(Configuration configuration) {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector(){

            public void customize(EndPoint endpoint, Request request) throws IOException {
                super.customize(endpoint, request);
                for (JettyConsolePlugin plugin : DefaultJettyManager.this.pluginManager.getPlugins()) {
                    plugin.customizeRequest(endpoint, request);
                }
            }
        };
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            plugin.customizeConnector(connector);
        }
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        handlers.setHandlers(new Handler[]{contexts});
        this.server.setHandler((Handler)handlers);
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            plugin.customizeServer(this.server);
        }
        File war = this.getWarLocation();
        this.webapp = new WebAppContext((HandlerContainer)contexts, war.getAbsolutePath(), configuration.getContextPath());
        for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
            plugin.beforeStart(this.webapp);
        }
        this.webapp.setAttribute("shutdownhook", (Object)this.shutdownHook);
        this.log.info("Added web application on path " + configuration.getContextPath() + " from war " + war.getAbsolutePath());
        this.log.info("Starting web application on port " + connector.getPort());
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JettyConsoleStarter.class.getClassLoader());
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    @Override
    public void stopServer() {
        if (this.webapp != null) {
            for (JettyConsolePlugin plugin : this.pluginManager.getPlugins()) {
                plugin.beforeStop(this.webapp);
            }
        }
        try {
            if (this.server != null && (this.server.isStarted() || this.server.isStarting())) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File getWarLocation() {
        URL resource = this.getClass().getResource("/WEB-INF/web.xml");
        String file = resource.getFile();
        file = file.substring("file:".length(), file.indexOf("!"));
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new File(file);
    }

    @Override
    public void addListener(JettyManager.JettyListener listener) {
        this.listenerList.add(listener);
    }
}

