package org.simplericity.jettyconsole.plugins;

import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.URIUtil;

/**
 */
public class SSLProxyPlugin extends JettyConsolePluginBase {

    private boolean sslProxy = false;

    private Logger log = LoggerFactory.getLogger(getClass());
    
    private StartOption sslOption = new DefaultStartOption("sslProxied", "Running behind an SSL proxy", "Options") {
        @Override
        public String validate() {
            log.info("Running behind SSL proxy, creating a connector that will customize requests and set HTTPS ");

            sslProxy = true;
            return null;
        }
    };

    public SSLProxyPlugin() {
        super(SSLProxyPlugin.class);
        addStartOptions(sslOption);
    }

    @Override
    public void customizeRequest(EndPoint endpoint, Request request) {
        if(sslProxy) {
            request.setScheme(URIUtil.HTTPS);
        }
    }
}
