package org.simplericity.jettyconsole.api;

/**
 */
public class DefaultStartOption implements StartOption {
    private String description;
    private String section;
    private String name;
    private String valueSample;
    private String value;

    public DefaultStartOption(String name, String description, String section) {
        this(name, null, description, section);
    }
    
    public DefaultStartOption(String name, String valueSample, String description, String section) {
        this.description = description;
        this.section = section;
        this.name = name;
        this.valueSample = valueSample;
    }

    public String getSection() {
        return section;
    }

    public String getName() {
        return name;
    }

    public String getValueSample() {
        return valueSample;
    }

    public String validate() {
        return null;
    }

    public String validate(String value) {
        this.value = value;
        return null;
    }

    public String getValueString() {
        if(getValueSample() == null) {
            throw new IllegalStateException("Option " + getName() +" does not take a value");
        }
        return value;
    }

    public String getRequiredValueMissingMessage() {
        return "--" + getName() +" option requires a value";
    }

    public String getDescription() {
        return description;
    }
}
