/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet5;

import io.telicent.servlet.auth.jwt.AbstractConfigurableFilterTests;
import io.telicent.servlet.auth.jwt.FilterConfigAdaptorWrapper;
import io.telicent.servlet.auth.jwt.JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.PathExclusion;
import io.telicent.servlet.auth.jwt.configuration.ClaimPath;
import io.telicent.servlet.auth.jwt.configuration.RuntimeConfigurationAdaptor;
import io.telicent.servlet.auth.jwt.servlet5.JwtAuthFilter;
import io.telicent.servlet.auth.jwt.servlet5.Servlet5FilterConfigAdaptor;
import io.telicent.servlet.auth.jwt.servlet5.Servlet5JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.servlet5.TestServlet5Engine;
import io.telicent.servlet.auth.jwt.sources.HeaderSource;
import io.telicent.servlet.auth.jwt.verification.JwtVerifier;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;

public class TestServlet5Filter
extends AbstractConfigurableFilterTests<HttpServletRequest, HttpServletResponse, JwtAuthFilter> {
    private ServletContext context;

    protected HttpServletRequest createMockRequest(String requestUri, Map<String, String> headers) {
        HttpServletRequest request = TestServlet5Engine.mockRequest(URI.create(requestUri), headers);
        Mockito.when((Object)request.getServletContext()).thenReturn((Object)this.context);
        return request;
    }

    protected HttpServletRequest createMockRequest(FilterConfigAdaptorWrapper config, Map<String, String> headers) {
        HttpServletRequest request = TestServlet5Engine.mockRequest(null, headers);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute((String)Mockito.any())).thenAnswer(a -> config.getAttribute((String)a.getArgument(0, String.class)));
        Mockito.when((Object)request.getServletContext()).thenReturn((Object)context);
        return request;
    }

    protected JwtAuthFilter createFilter(JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> engine, JwtVerifier verifier, List<PathExclusion> exclusions) {
        this.context = null;
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute((String)ArgumentMatchers.eq((Object)"io.telicent.servlet.auth.jwt.engine"))).thenReturn(engine);
        Mockito.when((Object)context.getAttribute((String)ArgumentMatchers.eq((Object)"io.telicent.servlet.auth.jwt.verifier"))).thenReturn((Object)verifier);
        Mockito.when((Object)context.getAttribute((String)ArgumentMatchers.eq((Object)"io.telicent.servlet.auth.jwt.path-exclusions"))).thenReturn(exclusions);
        this.context = context;
        return new JwtAuthFilter();
    }

    protected void invokeFilter(JwtAuthFilter filter, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            filter.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, (FilterChain)Mockito.mock(FilterChain.class));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected IO error: " + e.getMessage()));
        }
        catch (ServletException e) {
            Assert.fail((String)("Unexpected Servlet error: " + e.getMessage()));
        }
    }

    protected void verifyNoChallenge(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.never())).setStatus(Mockito.anyInt());
    }

    protected String getAuthenticatedUser(JwtAuthFilter filter, HttpServletRequest httpServletRequest) {
        HttpServletRequest authenticatedRequest = filter.lastResult();
        return authenticatedRequest != null ? authenticatedRequest.getRemoteUser() : null;
    }

    protected HttpServletRequest createMockRequest(Map<String, String> headers) {
        HttpServletRequest request = TestServlet5Engine.mockRequest(null, headers);
        Mockito.when((Object)request.getServletContext()).thenReturn((Object)this.context);
        return request;
    }

    protected HttpServletResponse createMockResponse() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine() {
        return new Servlet5JwtAuthenticationEngine();
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(String authHeader, String authHeaderPrefix, String realm, ClaimPath usernameClaim) {
        return new Servlet5JwtAuthenticationEngine(List.of(new HeaderSource(authHeader, authHeaderPrefix)), realm, usernameClaim != null ? List.of(usernameClaim) : null, null);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(List<HeaderSource> authHeaders, String realm, List<ClaimPath> usernameClaims) {
        return new Servlet5JwtAuthenticationEngine(authHeaders, realm, usernameClaims, null);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(List<HeaderSource> authHeaders, String realm, List<ClaimPath> usernameClaims, ClaimPath rolesClaim) {
        return new Servlet5JwtAuthenticationEngine(authHeaders, realm, usernameClaims, rolesClaim);
    }

    protected void verifyMissingRole(HttpServletRequest httpServletRequest, String role) {
        Assert.assertNotNull((Object)httpServletRequest);
        Assert.assertFalse((boolean)httpServletRequest.isUserInRole(role));
    }

    protected void verifyHasRole(HttpServletRequest httpServletRequest, String role) {
        Assert.assertNotNull((Object)httpServletRequest);
        Assert.assertTrue((boolean)httpServletRequest.isUserInRole(role));
    }

    protected void verifyStatusCode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int expectedStatus) throws IOException {
        TestServlet5Engine.verifyStatusCode(httpServletResponse, expectedStatus);
    }

    protected String verifyHeaderPresent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String expectedHeader) {
        return TestServlet5Engine.verifyHeaderPresent(httpServletResponse, expectedHeader);
    }

    protected String getAuthenticatedUser(HttpServletRequest authenticatedRequest) {
        return authenticatedRequest.getRemoteUser();
    }

    protected RuntimeConfigurationAdaptor createConfigAdaptor(final Map<String, String> configuration) {
        return new Servlet5FilterConfigAdaptor(new FilterConfig(){

            public String getFilterName() {
                return "Test";
            }

            public ServletContext getServletContext() {
                return (ServletContext)Mockito.mock(ServletContext.class);
            }

            public String getInitParameter(String name) {
                return (String)configuration.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(configuration.keySet());
            }
        });
    }

    protected JwtAuthFilter createUnconfiguredFilter() {
        return new JwtAuthFilter();
    }

    protected Object verifyRequestAttribute(HttpServletRequest httpServletRequest, String attribute) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
        ((HttpServletRequest)Mockito.verify((Object)httpServletRequest)).setAttribute((String)ArgumentMatchers.eq((Object)attribute), captor.capture());
        Object value = captor.getValue();
        Assert.assertNotNull((Object)value, (String)("Attribute " + attribute + " unexpectedly null"));
        return value;
    }
}

