/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet5;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.telicent.servlet.auth.jwt.configuration.ClaimPath;
import io.telicent.servlet.auth.jwt.roles.RolesHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.security.Principal;

public class AuthenticatedHttpServletRequest
extends HttpServletRequestWrapper {
    private final Jws<Claims> jws;
    private final String username;
    private final RolesHelper rolesHelper;

    public AuthenticatedHttpServletRequest(HttpServletRequest request, Jws<Claims> jws, String username, ClaimPath rolesClaim) {
        super(request);
        this.username = username;
        this.jws = jws;
        this.rolesHelper = this.createRolesHelper(jws, rolesClaim);
    }

    protected RolesHelper createRolesHelper(Jws<Claims> jws, ClaimPath rolesClaim) {
        return new RolesHelper(jws, rolesClaim);
    }

    public String getRemoteUser() {
        return this.username;
    }

    public Principal getUserPrincipal() {
        return () -> this.username;
    }

    public boolean isUserInRole(String role) {
        return this.rolesHelper != null && this.rolesHelper.isUserInRole(role);
    }

    public Jws<Claims> getVerifiedJwt() {
        return this.jws;
    }
}

