/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet5;

import io.telicent.servlet.auth.jwt.AbstractConfigurableJwtAuthFilter;
import io.telicent.servlet.auth.jwt.JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.servlet5.Servlet5FilterConfigAdaptor;
import io.telicent.servlet.auth.jwt.servlet5.Servlet5JwtAuthenticationEngine;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class JwtAuthFilter
extends AbstractConfigurableJwtAuthFilter<HttpServletRequest, HttpServletResponse>
implements Filter {
    private static final Servlet5JwtAuthenticationEngine DEFAULT_ENGINE = new Servlet5JwtAuthenticationEngine();

    public void init(FilterConfig filterConfig) {
        this.configure(new Servlet5FilterConfigAdaptor(filterConfig));
    }

    protected Object getAttribute(HttpServletRequest httpServletRequest, String attribute) {
        return httpServletRequest.getServletContext().getAttribute(attribute);
    }

    protected String getPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI();
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> getDefaultEngine() {
        return DEFAULT_ENGINE;
    }

    protected int getStatus(HttpServletResponse httpServletResponse) {
        return httpServletResponse.getStatus();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        super.doFilter((Object)request, (Object)response, (req, resp) -> {
            try {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    final HttpServletRequest lastResult() {
        return (HttpServletRequest)this.lastAuthenticatedRequest;
    }

    public void destroy() {
    }
}

