/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet5;

import io.telicent.servlet.auth.jwt.AbstractHeaderBasedEngineTests;
import io.telicent.servlet.auth.jwt.EqualsIgnoreCase;
import io.telicent.servlet.auth.jwt.JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.TestEnumeration;
import io.telicent.servlet.auth.jwt.servlet5.Servlet5JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.sources.HeaderSource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;

public class TestServlet5Engine
extends AbstractHeaderBasedEngineTests<HttpServletRequest, HttpServletResponse> {
    protected HttpServletRequest createMockRequest(Map<String, String> headers) {
        return TestServlet5Engine.mockRequest(null, headers);
    }

    public static HttpServletRequest mockRequest(URI requestUri, Map<String, String> headers) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        headers.forEach((key, value) -> {
            Mockito.when((Object)request.getHeader(EqualsIgnoreCase.eqIgnoresCase((String)key))).thenReturn(value);
            Mockito.when((Object)request.getHeaders(EqualsIgnoreCase.eqIgnoresCase((String)key))).thenReturn((Object)new TestEnumeration(Collections.singletonList(value)));
        });
        if (requestUri != null) {
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestUri.toString());
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)requestUri.getPath());
        }
        Mockito.when((Object)request.getAttribute((String)Mockito.any())).thenAnswer(invocationOnMock -> {
            ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
            ((HttpServletRequest)Mockito.verify((Object)request)).setAttribute((String)Mockito.eq((Object)((String)invocationOnMock.getArgument(0))), captor.capture());
            return captor.getValue();
        });
        return request;
    }

    protected HttpServletResponse createMockResponse() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine() {
        return new Servlet5JwtAuthenticationEngine();
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(String authHeader, String authHeaderPrefix, String realm, String usernameClaim) {
        return new Servlet5JwtAuthenticationEngine(List.of(new HeaderSource(authHeader, authHeaderPrefix)), realm, usernameClaim != null ? List.of(usernameClaim) : null);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(List<HeaderSource> authHeaders, String realm, List<String> usernameClaims) {
        return new Servlet5JwtAuthenticationEngine(authHeaders, realm, usernameClaims);
    }

    protected void verifyStatusCode(HttpServletRequest request, HttpServletResponse httpServletResponse, int expectedStatus) throws IOException {
        TestServlet5Engine.verifyStatusCode(httpServletResponse, expectedStatus);
    }

    public static void verifyStatusCode(HttpServletResponse httpServletResponse, int expectedStatus) throws IOException {
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.atMostOnce())).sendError(Mockito.eq((int)expectedStatus));
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.atMostOnce())).sendError(Mockito.eq((int)expectedStatus), (String)Mockito.any());
    }

    protected String verifyHeaderPresent(HttpServletRequest request, HttpServletResponse httpServletResponse, String expectedHeader) {
        return TestServlet5Engine.verifyHeaderPresent(httpServletResponse, expectedHeader);
    }

    public static String verifyHeaderPresent(HttpServletResponse httpServletResponse, String expectedHeader) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse)).addHeader((String)Mockito.eq((Object)expectedHeader), (String)captor.capture());
        return (String)captor.getValue();
    }

    protected String getAuthenticatedUser(HttpServletRequest authenticatedRequest) {
        return authenticatedRequest.getRemoteUser();
    }

    protected Object verifyRequestAttribute(HttpServletRequest httpServletRequest, String attribute) {
        Object value = httpServletRequest.getAttribute(attribute);
        Assert.assertNotNull((Object)value, (String)("Attribute " + attribute + " unexpectedly null"));
        return value;
    }
}

