/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet3;

import io.telicent.servlet.auth.jwt.AbstractHeaderBasedEngineTests;
import io.telicent.servlet.auth.jwt.EqualsIgnoreCase;
import io.telicent.servlet.auth.jwt.JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.TestEnumeration;
import io.telicent.servlet.auth.jwt.configuration.ClaimPath;
import io.telicent.servlet.auth.jwt.servlet3.Servlet3JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.sources.HeaderSource;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;

public class TestServlet3Engine
extends AbstractHeaderBasedEngineTests<HttpServletRequest, HttpServletResponse> {
    protected HttpServletRequest createMockRequest(Map<String, String> headers) {
        return TestServlet3Engine.mockRequest(null, headers);
    }

    public static HttpServletRequest mockRequest(URI requestUri, Map<String, String> headers) {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        headers.forEach((key, value) -> {
            Mockito.when((Object)request.getHeader(EqualsIgnoreCase.eqIgnoresCase((String)key))).thenReturn(value);
            Mockito.when((Object)request.getHeaders(EqualsIgnoreCase.eqIgnoresCase((String)key))).thenReturn((Object)new TestEnumeration(Collections.singletonList(value)));
        });
        if (requestUri != null) {
            Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestUri.toString());
            Mockito.when((Object)request.getPathInfo()).thenReturn((Object)requestUri.getPath());
        }
        Mockito.when((Object)request.getAttribute((String)Mockito.any())).thenAnswer(invocationOnMock -> {
            ArgumentCaptor captor = ArgumentCaptor.forClass(Object.class);
            ((HttpServletRequest)Mockito.verify((Object)request)).setAttribute((String)ArgumentMatchers.eq((Object)((String)invocationOnMock.getArgument(0))), captor.capture());
            return captor.getValue();
        });
        return request;
    }

    protected HttpServletResponse createMockResponse() {
        return (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine() {
        return new Servlet3JwtAuthenticationEngine();
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(String authHeader, String authHeaderPrefix, String realm, ClaimPath usernameClaim) {
        return new Servlet3JwtAuthenticationEngine(List.of(new HeaderSource(authHeader, authHeaderPrefix)), realm, usernameClaim != null ? List.of(usernameClaim) : null, null);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(List<HeaderSource> authHeaders, String realm, List<ClaimPath> usernameClaims) {
        return new Servlet3JwtAuthenticationEngine(authHeaders, realm, usernameClaims, null);
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> createEngine(List<HeaderSource> authHeaders, String realm, List<ClaimPath> usernameClaims, ClaimPath rolesClaim) {
        return new Servlet3JwtAuthenticationEngine(authHeaders, realm, usernameClaims, rolesClaim);
    }

    protected void verifyHasRole(HttpServletRequest httpServletRequest, String role) {
        Assert.assertNotNull((Object)httpServletRequest);
        Assert.assertTrue((boolean)httpServletRequest.isUserInRole(role));
    }

    protected void verifyMissingRole(HttpServletRequest httpServletRequest, String role) {
        Assert.assertNotNull((Object)httpServletRequest);
        Assert.assertFalse((boolean)httpServletRequest.isUserInRole(role));
    }

    protected void verifyStatusCode(HttpServletRequest request, HttpServletResponse httpServletResponse, int expectedStatus) throws IOException {
        TestServlet3Engine.verifyStatusCode(httpServletResponse, expectedStatus);
    }

    public static void verifyStatusCode(HttpServletResponse httpServletResponse, int expectedStatus) throws IOException {
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.atMostOnce())).sendError(ArgumentMatchers.eq((int)expectedStatus));
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.atMostOnce())).sendError(ArgumentMatchers.eq((int)expectedStatus), (String)Mockito.any());
    }

    protected String verifyHeaderPresent(HttpServletRequest request, HttpServletResponse httpServletResponse, String expectedHeader) {
        return TestServlet3Engine.verifyHeaderPresent(httpServletResponse, expectedHeader);
    }

    public static String verifyHeaderPresent(HttpServletResponse httpServletResponse, String expectedHeader) {
        ArgumentCaptor valueCapture = ArgumentCaptor.forClass(String.class);
        ((HttpServletResponse)Mockito.verify((Object)httpServletResponse, (VerificationMode)Mockito.times((int)1))).addHeader((String)ArgumentMatchers.eq((Object)expectedHeader), (String)valueCapture.capture());
        return (String)valueCapture.getValue();
    }

    protected String getAuthenticatedUser(HttpServletRequest authenticatedRequest) {
        return authenticatedRequest.getRemoteUser();
    }

    protected Object verifyRequestAttribute(HttpServletRequest httpServletRequest, String attribute) {
        Object value = httpServletRequest.getAttribute(attribute);
        Assert.assertNotNull((Object)value, (String)("Attribute " + attribute + " unexpectedly null"));
        return value;
    }
}

