/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet3;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.telicent.servlet.auth.jwt.HeaderBasedJwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.JwtHttpConstants;
import io.telicent.servlet.auth.jwt.challenges.Challenge;
import io.telicent.servlet.auth.jwt.challenges.TokenCandidate;
import io.telicent.servlet.auth.jwt.servlet3.AuthenticatedHttpServletRequest;
import io.telicent.servlet.auth.jwt.sources.HeaderSource;
import io.telicent.servlet.auth.jwt.sources.TokenSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet3JwtAuthenticationEngine
extends HeaderBasedJwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Servlet3JwtAuthenticationEngine.class);

    public Servlet3JwtAuthenticationEngine() {
        this(JwtHttpConstants.DEFAULT_HEADER_SOURCES, null, null);
    }

    public Servlet3JwtAuthenticationEngine(Collection<HeaderSource> headers, String realm, Collection<String> usernameClaims) {
        super(headers, realm, usernameClaims);
    }

    protected boolean hasRequiredParameters(HttpServletRequest request) {
        return this.headers.stream().anyMatch(h -> StringUtils.isNotBlank((CharSequence)request.getHeader(h.getHeader())));
    }

    protected List<TokenCandidate> extractTokens(HttpServletRequest request) {
        ArrayList<TokenCandidate> candidates = new ArrayList<TokenCandidate>();
        for (HeaderSource header : this.headers) {
            Enumeration headerValues = request.getHeaders(header.getHeader());
            if (headerValues == null) continue;
            while (headerValues.hasMoreElements()) {
                candidates.add(new TokenCandidate((TokenSource)header, (String)headerValues.nextElement()));
            }
        }
        return candidates;
    }

    protected HttpServletRequest prepareRequest(HttpServletRequest request, Jws<Claims> jws, String username) {
        return new AuthenticatedHttpServletRequest(request, jws, username);
    }

    protected void sendChallenge(HttpServletRequest request, HttpServletResponse response, Challenge challenge) {
        String realm = this.selectRealm(JwtHttpConstants.sanitiseHeaderParameterValue((String)request.getRequestURI()));
        Map additionalParams = this.buildChallengeParameters(challenge.errorCode(), challenge.errorDescription());
        response.addHeader("WWW-Authenticate", this.buildAuthorizationHeader(realm, additionalParams));
        try {
            response.sendError(challenge.statusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sendError(HttpServletResponse response, Throwable err) {
        try {
            response.sendError(500, "Unexpected error during JWT authentication");
            LOGGER.warn("Unexpected error during JWT Authentication: ", err);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRequestUrl(HttpServletRequest request) {
        return request.getRequestURI();
    }

    protected void setRequestAttribute(HttpServletRequest request, String attribute, Object value) {
        request.setAttribute(attribute, value);
    }
}

