/*
 * Decompiled with CFR 0.152.
 */
package io.telicent.servlet.auth.jwt.servlet3;

import io.telicent.servlet.auth.jwt.AbstractConfigurableJwtAuthFilter;
import io.telicent.servlet.auth.jwt.JwtAuthenticationEngine;
import io.telicent.servlet.auth.jwt.servlet3.Servlet3FilterConfigAdaptor;
import io.telicent.servlet.auth.jwt.servlet3.Servlet3JwtAuthenticationEngine;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JwtAuthFilter
extends AbstractConfigurableJwtAuthFilter<HttpServletRequest, HttpServletResponse>
implements Filter {
    protected static final Servlet3JwtAuthenticationEngine DEFAULT_ENGINE = new Servlet3JwtAuthenticationEngine();

    public void init(FilterConfig filterConfig) {
        this.configure(new Servlet3FilterConfigAdaptor(filterConfig));
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        super.doFilter((Object)request, (Object)response, (req, resp) -> {
            try {
                filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected Object getAttribute(HttpServletRequest httpServletRequest, String attribute) {
        return httpServletRequest.getServletContext().getAttribute(attribute);
    }

    protected String getPath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI();
    }

    protected JwtAuthenticationEngine<HttpServletRequest, HttpServletResponse> getDefaultEngine() {
        return DEFAULT_ENGINE;
    }

    protected int getStatus(HttpServletResponse httpServletResponse) {
        return httpServletResponse.getStatus();
    }

    final HttpServletRequest lastResult() {
        return (HttpServletRequest)this.lastAuthenticatedRequest;
    }

    public void destroy() {
    }
}

