/*
 * Decompiled with CFR 0.152.
 */
package io.telereso.kmp.core;

import io.ktor.util.Base64Kt;
import io.telereso.kmp.core.Http;
import io.telereso.kmp.core.Utils;
import io.telereso.kmp.core.models.ClientException;
import io.telereso.kmp.core.models.ClientExceptionKt;
import io.telereso.kmp.core.models.JwtPayload;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lio/telereso/kmp/core/Utils;", "", "()V", "jsonPrettySerializer", "Lkotlinx/serialization/json/Json;", "getJsonPrettySerializer", "()Lkotlinx/serialization/json/Json;", "jsonSerializer", "getJsonSerializer", "unitTestInstance", "Lkotlinx/datetime/Instant;", "getUnitTestInstance", "()Lkotlinx/datetime/Instant;", "setUnitTestInstance", "(Lkotlinx/datetime/Instant;)V", "getDecodedResponse", "", "", "fromToken", "getExpiryTime", "", "response", "getJsonBody", "encodeJwt", "hasJwtExpired", "", "token", "tokenBufferTime", "", "core"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final Json jsonSerializer = JsonKt.Json$default(null, (Function1)jsonSerializer.1.INSTANCE, (int)1, null);
    @NotNull
    private static final Json jsonPrettySerializer = JsonKt.Json$default(null, (Function1)jsonPrettySerializer.1.INSTANCE, (int)1, null);
    @Nullable
    private static Instant unitTestInstance;

    private Utils() {
    }

    @NotNull
    public final Json getJsonSerializer() {
        return jsonSerializer;
    }

    @NotNull
    public final Json getJsonPrettySerializer() {
        return jsonPrettySerializer;
    }

    @Nullable
    public final Instant getUnitTestInstance() {
        return unitTestInstance;
    }

    public final void setUnitTestInstance(@Nullable Instant instant) {
        unitTestInstance = instant;
    }

    private final String getJsonBody(String encodeJwt) {
        String string;
        try {
            String[] stringArray = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)encodeJwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            string = Base64Kt.decodeBase64String((String)split[1]);
        }
        catch (Throwable e) {
            ClientException.Companion.getListener().invoke((Object)ClientExceptionKt.asClientException(e));
            string = "";
        }
        return string;
    }

    public final boolean hasJwtExpired(@NotNull String token, int tokenBufferTime) {
        long currentDate;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        long expiryDate = this.getExpiryTime(token) - (long)tokenBufferTime;
        if (expiryDate <= 0L) {
            return true;
        }
        Instant instant = unitTestInstance;
        if (instant == null) {
            instant = Clock.System.INSTANCE.now();
        }
        return (currentDate = instant.toEpochMilliseconds() / (long)1000) >= expiryDate;
    }

    private final long getExpiryTime(String response) throws NullPointerException {
        long l;
        String jsonBody = this.getJsonBody(response);
        try {
            StringFormat $this$decodeFromString$iv = (StringFormat)Http.INSTANCE.getKtorConfigJson();
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JwtPayload.class));
            boolean $i$f$cast = false;
            JwtPayload decodedResponse = (JwtPayload)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonBody);
            Long l2 = decodedResponse.getExp();
            if (l2 == null) {
                throw ClientExceptionKt.asClientException(new NullPointerException("expire time cannot be null."));
            }
            l = l2;
        }
        catch (Throwable e) {
            ClientException.Companion.getListener().invoke((Object)ClientExceptionKt.asClientException(e));
            throw ClientExceptionKt.asClientException(e);
        }
        return l;
    }

    @NotNull
    public final Map<String, String> getDecodedResponse(@NotNull String fromToken) throws Throwable {
        Map map;
        Intrinsics.checkNotNullParameter((Object)fromToken, (String)"fromToken");
        String jsonBody = this.getJsonBody(fromToken);
        try {
            StringFormat $this$decodeFromString$iv = (StringFormat)Http.INSTANCE.getKtorConfigJson();
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))));
            boolean $i$f$cast = false;
            map = (Map)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonBody);
        }
        catch (Throwable e) {
            ClientException.Companion.getListener().invoke((Object)ClientExceptionKt.asClientException(e));
            throw e;
        }
        return map;
    }
}

