package io.telereso.kmp.core.models

import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
import kotlin.js.JsExport
import kotlin.js.JsName

@JsExport()
@JsName("ErrorBodyToJson")
fun ErrorBody.toJson(): String {
   return ClientExceptionJsonSerializer.encodeToString(ErrorBody.serializer(), this)
}

@JsExport()
@JsName("ErrorBodyToJsonPretty")
fun ErrorBody.toJsonPretty(): String {
   return ClientExceptionJsonPrettySerializer.encodeToString(ErrorBody.serializer(), this)
}

@JsExport
@JsName("ErrorBodyFromJson")
fun ErrorBody.Companion.fromJson(json:String?): ErrorBody{
   return ClientExceptionJsonSerializer.decodeFromString(json ?: "{}")
}

@JsExport
@JsName("ErrorBodyToJsonArray")
fun ErrorBody.Companion.toJson(array: Array<ErrorBody>): String {
   return ClientExceptionJsonSerializer.encodeToString(ListSerializer(ErrorBody.serializer()), array.toList())
}

@JsExport
@JsName("ErrorBodyFromJsonArray")
fun ErrorBody.Companion.fromJsonArray(json:String?): Array<ErrorBody> {
   return ClientExceptionJsonSerializer.decodeFromString(ListSerializer(ErrorBody.serializer()), json ?: "[]").toTypedArray()
}

