package io.telereso.kmp.core

import io.telereso.kmp.core.TaskConfig.*
import kotlin.js.JsExport

import kotlin.jvm.JvmStatic

@JsExport
class TaskConfigBuilder() {
    private var _retry: Int? = null
    private var _backOffDelay: Int? = null
    private var _startDelay: Int? = null
    private var _timeout: Int? = null

    fun retry(retry: Int?): TaskConfigBuilder {
        _retry = retry
        return this
    }
        
    fun backOffDelay(backOffDelay: Int?): TaskConfigBuilder {
        _backOffDelay = backOffDelay
        return this
    }
        
    fun startDelay(startDelay: Int?): TaskConfigBuilder {
        _startDelay = startDelay
        return this
    }
        
    fun timeout(timeout: Int?): TaskConfigBuilder {
        _timeout = timeout
        return this
    }
        

    fun build(): TaskConfig {
        return TaskConfig(_retry,_backOffDelay,_startDelay,_timeout)
    } 
    
    companion object {
      @JvmStatic
      fun builder(): TaskConfigBuilder {
          return TaskConfigBuilder()
      }
    }
    
}