package io.telereso.kmp.core.models

import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
import kotlin.js.JsExport
import kotlin.js.JsName

@JsExport()
@JsName("ClientExceptionToJson")
fun ClientException.toJson(): String {
   return ClientExceptionJsonSerializer.encodeToString(ClientException.serializer(), this)
}

@JsExport()
@JsName("ClientExceptionToJsonPretty")
fun ClientException.toJsonPretty(): String {
   return ClientExceptionJsonPrettySerializer.encodeToString(ClientException.serializer(), this)
}

@JsExport
@JsName("ClientExceptionFromJson")
fun ClientException.Companion.fromJson(json:String?): ClientException{
   return ClientExceptionJsonSerializer.decodeFromString(json ?: "{}")
}

@JsExport
@JsName("ClientExceptionToJsonArray")
fun ClientException.Companion.toJson(array: Array<ClientException>): String {
   return ClientExceptionJsonSerializer.encodeToString(ListSerializer(ClientException.serializer()), array.toList())
}

@JsExport
@JsName("ClientExceptionFromJsonArray")
fun ClientException.Companion.fromJsonArray(json:String?): Array<ClientException> {
   return ClientExceptionJsonSerializer.decodeFromString(ListSerializer(ClientException.serializer()), json ?: "[]").toTypedArray()
}

