package io.telereso.kmp.core.models

import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
import kotlin.js.JsExport
import kotlin.js.JsName

@JsExport()
@JsName("JwtPayloadToJson")
fun JwtPayload.toJson(): String {
   return ClientExceptionJsonSerializer.encodeToString(JwtPayload.serializer(), this)
}

@JsExport()
@JsName("JwtPayloadToJsonPretty")
fun JwtPayload.toJsonPretty(): String {
   return ClientExceptionJsonPrettySerializer.encodeToString(JwtPayload.serializer(), this)
}

@JsExport
@JsName("JwtPayloadFromJson")
fun JwtPayload.Companion.fromJson(json:String?): JwtPayload{
   return ClientExceptionJsonSerializer.decodeFromString(json ?: "{}")
}

@JsExport
@JsName("JwtPayloadToJsonArray")
fun JwtPayload.Companion.toJson(array: Array<JwtPayload>): String {
   return ClientExceptionJsonSerializer.encodeToString(ListSerializer(JwtPayload.serializer()), array.toList())
}

@JsExport
@JsName("JwtPayloadFromJsonArray")
fun JwtPayload.Companion.fromJsonArray(json:String?): Array<JwtPayload> {
   return ClientExceptionJsonSerializer.decodeFromString(ListSerializer(JwtPayload.serializer()), json ?: "[]").toTypedArray()
}

