package io.telereso.kmp.core.models

import io.telereso.kmp.core.models.ErrorBody.*
import kotlin.js.JsExport

import kotlin.jvm.JvmStatic

@JsExport
class ErrorBodyBuilder() {
    private var _code: String? = null
    private var _message: String? = null

    fun code(code: String?): ErrorBodyBuilder {
        _code = code
        return this
    }
        
    fun message(message: String?): ErrorBodyBuilder {
        _message = message
        return this
    }
        

    fun build(): ErrorBody {
        return ErrorBody(_code,_message)
    } 
    
    companion object {
      @JvmStatic
      fun builder(): ErrorBodyBuilder {
          return ErrorBodyBuilder()
      }
    }
    
}