package io.telereso.kmp.core.models

// import JwtPayload
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
import kotlin.js.JsExport
import kotlin.js.JsName

@JsExport()
@JsName("JwtPayloadToJson")
fun JwtPayload.toJson(): String {
   return jsonSerializer.encodeToString(JwtPayload.serializer(), this)
}

@JsExport()
@JsName("JwtPayloadToJsonPretty")
fun JwtPayload.toJsonPretty(): String {
   return jsonPrettySerializer.encodeToString(JwtPayload.serializer(), this)
}

@JsExport
@JsName("JwtPayloadFromJson")
fun JwtPayload.Companion.fromJson(json:String): JwtPayload{
   return jsonSerializer.decodeFromString(json)
}

@JsExport
@JsName("JwtPayloadToJsonArray")
fun JwtPayload.Companion.toJson(array: Array<JwtPayload>): String {
   return jsonSerializer.encodeToString(ListSerializer(JwtPayload.serializer()), array.toList())
}

@JsExport
@JsName("JwtPayloadFromJsonArray")
fun JwtPayload.Companion.fromJsonArray(json:String): Array<JwtPayload> {
   return jsonSerializer.decodeFromString(ListSerializer(JwtPayload.serializer()), json).toTypedArray()
}

