package io.telereso.kmp.core.models

// import ErrorBody
import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
import kotlin.js.JsExport
import kotlin.js.JsName

@JsExport()
@JsName("ErrorBodyToJson")
fun ErrorBody.toJson(): String {
   return jsonSerializer.encodeToString(ErrorBody.serializer(), this)
}

@JsExport()
@JsName("ErrorBodyToJsonPretty")
fun ErrorBody.toJsonPretty(): String {
   return jsonPrettySerializer.encodeToString(ErrorBody.serializer(), this)
}

@JsExport
@JsName("ErrorBodyFromJson")
fun ErrorBody.Companion.fromJson(json:String): ErrorBody{
   return jsonSerializer.decodeFromString(json)
}

@JsExport
@JsName("ErrorBodyToJsonArray")
fun ErrorBody.Companion.toJson(array: Array<ErrorBody>): String {
   return jsonSerializer.encodeToString(ListSerializer(ErrorBody.serializer()), array.toList())
}

@JsExport
@JsName("ErrorBodyFromJsonArray")
fun ErrorBody.Companion.fromJsonArray(json:String): Array<ErrorBody> {
   return jsonSerializer.decodeFromString(ListSerializer(ErrorBody.serializer()), json).toTypedArray()
}

