package io.telereso.kmp.core.models

import kotlinx.serialization.builtins.ListSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json
// import kotlin.js.JsExport
// import kotlin.js.JsName

// @JsExport()
// @JsName("ExpirableValueToJson")
fun ExpirableValue.toJson(): String {
   return jsonSerializer.encodeToString(ExpirableValue.serializer(), this)
}

// @JsExport()
// @JsName("ExpirableValueToJsonPretty")
fun ExpirableValue.toJsonPretty(): String {
   return jsonPrettySerializer.encodeToString(ExpirableValue.serializer(), this)
}

// @JsExport
// @JsName("ExpirableValueFromJson")
fun ExpirableValue.Companion.fromJson(json:String): ExpirableValue{
   return jsonSerializer.decodeFromString(json)
}

// @JsExport
// @JsName("ExpirableValueToJsonArray")
fun ExpirableValue.Companion.toJson(array: Array<ExpirableValue>): String {
   return jsonSerializer.encodeToString(ListSerializer(ExpirableValue.serializer()), array.toList())
}

// @JsExport
// @JsName("ExpirableValueFromJsonArray")
fun ExpirableValue.Companion.fromJsonArray(json:String): Array<ExpirableValue> {
   return jsonSerializer.decodeFromString(ListSerializer(ExpirableValue.serializer()), json).toTypedArray()
}

