/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.maven.watchdog;

import io.takari.incrementalbuild.maven.internal.MavenIncrementalConventions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.ProjectExecutionEvent;
import org.apache.maven.execution.ProjectExecutionListener;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

@Named
@Singleton
public class ProjectBuildContextManager
implements ProjectExecutionListener,
MojoExecutionListener {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String CTX_EXECUTIONS = "buildavoidance.executions";
    private static final String CTX_DEFAULT_LIFECYCLE_START = "buildavoidance.default-lifecycle-start";
    private final Map<String, Lifecycle> phaseToLifecycleMap;
    private final MavenIncrementalConventions conventions;

    @Inject
    public ProjectBuildContextManager(DefaultLifecycles defaultLifecycles, MavenIncrementalConventions conventions) {
        this.conventions = conventions;
        this.phaseToLifecycleMap = Collections.unmodifiableMap(defaultLifecycles.getPhaseToLifecycleMap());
    }

    public void beforeProjectLifecycleExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
        List executionPlan = event.getExecutionPlan();
        MavenProject project = event.getProject();
        List<MojoExecution> defaultPlan = this.getDefaultLifecycle(executionPlan);
        if (defaultPlan.isEmpty()) {
            return;
        }
        LinkedHashMap<String, List<String>> phases = new LinkedHashMap<String, List<String>>();
        for (MojoExecution execution : defaultPlan) {
            ArrayList<String> executions = (ArrayList<String>)phases.get(execution.getLifecyclePhase());
            if (executions == null) {
                executions = new ArrayList<String>();
                phases.put(execution.getLifecyclePhase(), executions);
            }
            executions.add(this.conventions.getExecutionId(execution));
        }
        if (!this.isCleanBuild(executionPlan)) {
            Map.Entry phaseEntry;
            List<String> previousExecutions;
            LinkedHashMap<String, List<String>> previousPhases = this.loadPhases(project);
            Iterator i$ = phases.entrySet().iterator();
            while (i$.hasNext() && (previousExecutions = previousPhases.get((phaseEntry = i$.next()).getKey())) != null) {
                List executions = (List)phaseEntry.getValue();
                ArrayList<String> removedExecutions = new ArrayList<String>();
                for (String execution : previousExecutions) {
                    if (executions.contains(execution)) continue;
                    removedExecutions.add(execution);
                }
                if (removedExecutions.isEmpty()) continue;
                StringBuilder msg = new StringBuilder();
                msg.append("Could not perform incremental build for ").append(project.toString());
                msg.append("\n   removed plugin executions since last clean build:");
                for (String execution : removedExecutions) {
                    msg.append(' ').append(execution);
                }
                msg.append("\nPlease restart the build with 'clean',");
                throw new LifecycleExecutionException(msg.toString(), project);
            }
            String lastPhase = defaultPlan.get(defaultPlan.size() - 1).getLifecyclePhase();
            Iterator<Map.Entry<String, List<String>>> previousPhaseIter = previousPhases.entrySet().iterator();
            while (previousPhaseIter.hasNext() && !lastPhase.equals(previousPhaseIter.next().getKey())) {
            }
            while (previousPhaseIter.hasNext()) {
                Map.Entry<String, List<String>> previousPhase = previousPhaseIter.next();
                phases.put(previousPhase.getKey(), previousPhase.getValue());
            }
        }
        project.setContextValue(CTX_DEFAULT_LIFECYCLE_START, (Object)this.conventions.getExecutionId(defaultPlan.get(0)));
        project.setContextValue(CTX_EXECUTIONS, phases);
    }

    private List<MojoExecution> getDefaultLifecycle(List<MojoExecution> executionPlan) {
        ArrayList<MojoExecution> result = new ArrayList<MojoExecution>();
        for (MojoExecution execution : executionPlan) {
            if (!"default".equals(this.getLifecycleId(execution))) continue;
            result.add(execution);
        }
        return result;
    }

    private String getLifecycleId(MojoExecution execution) {
        Lifecycle lifecycle;
        if (execution.getSource() == MojoExecution.Source.LIFECYCLE && (lifecycle = this.phaseToLifecycleMap.get(execution.getLifecyclePhase())) != null) {
            return lifecycle.getId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, List<String>> loadPhases(MavenProject project) throws LifecycleExecutionException {
        LinkedHashMap<String, List<String>> phases = new LinkedHashMap<String, List<String>>();
        File state = this.getExecutionsListLocation(project);
        if (state.exists()) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(state), UTF_8));
                try {
                    String str;
                    while ((str = reader.readLine()) != null) {
                        lines.add(str);
                    }
                }
                finally {
                    IOUtil.close((Reader)reader);
                }
            }
            catch (IOException e) {
                throw new LifecycleExecutionException("Could not maintainer incremental build state for " + project, (Throwable)e);
            }
            for (String line : lines) {
                int idx = line.indexOf(58);
                if (idx <= 0) {
                    throw new LifecycleExecutionException("Invalid file format " + state, project);
                }
                String phase = line.substring(0, idx);
                List<String> executions = phases.get(phase);
                if (executions == null) {
                    executions = new ArrayList<String>();
                    phases.put(phase, executions);
                }
                executions.add(line.substring(idx + 1));
            }
        }
        return phases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePhases(MavenProject project, LinkedHashMap<String, List<String>> phases) throws IOException {
        File state = this.getExecutionsListLocation(project);
        if (!state.getParentFile().exists() && !state.getParentFile().mkdirs()) {
            throw new IOException("Could not create parent directories " + state);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(state), UTF_8));
        try {
            for (Map.Entry<String, List<String>> phase : phases.entrySet()) {
                for (String execution : phase.getValue()) {
                    writer.write(phase.getKey() + ":" + execution);
                    writer.write(10);
                }
            }
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private File getExecutionsListLocation(MavenProject project) {
        return new File(this.conventions.getProjectStateLocation(project), "executions.lst");
    }

    private boolean isCleanBuild(List<MojoExecution> executionPlan) {
        for (MojoExecution execution : executionPlan) {
            String lifecycleId = this.getLifecycleId(execution);
            if (lifecycleId == null) continue;
            return "clean".equals(lifecycleId);
        }
        return false;
    }

    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        MojoExecution execution = event.getExecution();
        MavenProject project = event.getProject();
        String defaultLifecycleStart = (String)project.getContextValue(CTX_DEFAULT_LIFECYCLE_START);
        if (defaultLifecycleStart != null && defaultLifecycleStart.equals(this.conventions.getExecutionId(execution))) {
            LinkedHashMap phases = (LinkedHashMap)project.getContextValue(CTX_EXECUTIONS);
            try {
                this.storePhases(project, phases);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not maintainer incremental build state for " + project, (Exception)e);
            }
        }
    }

    public void beforeProjectExecution(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void afterProjectExecutionSuccess(ProjectExecutionEvent event) throws LifecycleExecutionException {
    }

    public void afterProjectExecutionFailure(ProjectExecutionEvent event) {
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
    }
}

