package com.syrf.location.utils

object Constants {
    private const val PACKAGE_NAME = "com.syrf.location"
    const val SDK_KEY_NAME = "io.syrf.sdk.API_KEY"

    // Location
    const val NAVIGATION_CHANNEL_ID = "SyrfNavigationService"
    const val NAVIGATION_NOTIFICATION_ID = 1006

    const val NOTIFICATION_CHANNEL_ID = "SyrfLocationService"
    const val LOCATION_NOTIFICATION_ID = 1001
    const val ACTION_LOCATION_BROADCAST = "$PACKAGE_NAME.action.LOCATION_BROADCAST"
    const val ACTION_NAVIGATION_BROADCAST = "$PACKAGE_NAME.action.NAVIGATION_BROADCAST"
    const val EXTRA_LOCATION = "$PACKAGE_NAME.extra.LOCATION"
    const val EXTRA_NAVIGATION= "$PACKAGE_NAME.extra.NAVIGATION"
    const val EXTRA_CANCEL_LOCATION_TRACKING_FROM_NOTIFICATION =
        "$PACKAGE_NAME.extra.CANCEL_LOCATION_TRACKING_FROM_NOTIFICATION"

    // Accelerometer sensor
    const val ACCELERO_NOTIFICATION_CHANNEL_ID = "SyrfAcceleroSensorService"
    const val ACCELERO_NOTIFICATION_ID = 1002
    const val ACTION_ACCELERO_SENSOR_BROADCAST = "$PACKAGE_NAME.action.ACCELERO_SENSOR_BROADCAST"
    const val EXTRA_ACCELERO_SENSOR_DATA = "$PACKAGE_NAME.extra.ACCELERO_SENSOR_DATA"
    const val EXTRA_CANCEL_ACCELERO_SENSOR_TRACKING_FROM_NOTIFICATION =
        "$PACKAGE_NAME.extra.CANCEL_ACCELERO_SENSOR_TRACKING_FROM_NOTIFICATION"

    // Magnetic sensor
    const val MAGNETIC_NOTIFICATION_CHANNEL_ID = "SyrfMagneticSensorService"
    const val MAGNETIC_NOTIFICATION_ID = 1003
    const val ACTION_MAGNETIC_SENSOR_BROADCAST = "$PACKAGE_NAME.action.MAGNETIC_SENSOR_BROADCAST"
    const val EXTRA_MAGNETIC_SENSOR_DATA = "$PACKAGE_NAME.extra.MAGNETIC_SENSOR_DATA"
    const val EXTRA_CANCEL_MAGNETIC_SENSOR_TRACKING_FROM_NOTIFICATION =
        "$PACKAGE_NAME.extra.CANCEL_MAGNETIC_SENSOR_TRACKING_FROM_NOTIFICATION"

    // Gyroscope sensor
    const val GYROSCOPE_NOTIFICATION_CHANNEL_ID = "SyrfGyroscopeSensorService"
    const val GYROSCOPE_NOTIFICATION_ID = 1004
    const val ACTION_GYROSCOPE_SENSOR_BROADCAST = "$PACKAGE_NAME.action.GYROSCOPE_SENSOR_BROADCAST"
    const val EXTRA_GYROSCOPE_SENSOR_DATA = "$PACKAGE_NAME.extra.GYROSCOPE_SENSOR_DATA"
    const val EXTRA_CANCEL_GYROSCOPE_SENSOR_TRACKING_FROM_NOTIFICATION =
        "$PACKAGE_NAME.extra.CANCEL_GYROSCOPE_SENSOR_TRACKING_FROM_NOTIFICATION"

    // Rotation sensor
    const val ROTATION_NOTIFICATION_CHANNEL_ID = "SyrfRotationSensorService"
    const val ROTATION_NOTIFICATION_ID = 1005
    const val ACTION_ROTATION_SENSOR_BROADCAST = "$PACKAGE_NAME.action.ROTATION_SENSOR_BROADCAST"
    const val EXTRA_ROTATION_SENSOR_DATA = "$PACKAGE_NAME.extra.ROTATION_SENSOR_DATA"
    const val EXTRA_CANCEL_ROTATION_SENSOR_TRACKING_FROM_NOTIFICATION =
        "$PACKAGE_NAME.extra.CANCEL_ROTATION_SENSOR_TRACKING_FROM_NOTIFICATION"


}