package io.syndesis.verifier;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link Verifier.Result}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResult.builder()}.
 */
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Verifier.Result"})
@Immutable
public final class ImmutableResult implements Verifier.Result {
  private final Verifier.Result.Status status;
  private final Verifier.Scope scope;
  private final List<Verifier.VerifierError> errors;

  private ImmutableResult(
      Verifier.Result.Status status,
      Verifier.Scope scope,
      List<Verifier.VerifierError> errors) {
    this.status = status;
    this.scope = scope;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public Verifier.Result.Status getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code scope} attribute
   */
  @JsonProperty("scope")
  @Override
  public Verifier.Scope getScope() {
    return scope;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public List<Verifier.VerifierError> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verifier.Result#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResult withStatus(Verifier.Result.Status value) {
    if (this.status == value) return this;
    Verifier.Result.Status newValue = Objects.requireNonNull(value, "status");
    return new ImmutableResult(newValue, this.scope, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verifier.Result#getScope() scope} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scope
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResult withScope(Verifier.Scope value) {
    if (this.scope == value) return this;
    Verifier.Scope newValue = Objects.requireNonNull(value, "scope");
    return new ImmutableResult(this.status, newValue, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Verifier.Result#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResult withErrors(Verifier.VerifierError... elements) {
    List<Verifier.VerifierError> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableResult(this.status, this.scope, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Verifier.Result#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableResult withErrors(Iterable<? extends Verifier.VerifierError> elements) {
    if (this.errors == elements) return this;
    List<Verifier.VerifierError> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableResult(this.status, this.scope, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResult
        && equalTo((ImmutableResult) another);
  }

  private boolean equalTo(ImmutableResult another) {
    return status.equals(another.status)
        && scope.equals(another.scope)
        && errors.equals(another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code status}, {@code scope}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + status.hashCode();
    h += (h << 5) + scope.hashCode();
    h += (h << 5) + errors.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Result} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Result{"
        + "status=" + status
        + ", scope=" + scope
        + ", errors=" + errors
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Verifier.Result} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Result instance
   */
  public static ImmutableResult copyOf(Verifier.Result instance) {
    if (instance instanceof ImmutableResult) {
      return (ImmutableResult) instance;
    }
    return ImmutableResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResult ImmutableResult}.
   * @return A new ImmutableResult builder
   */
  public static ImmutableResult.Builder builder() {
    return new ImmutableResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResult ImmutableResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STATUS = 0x1L;
    private static final long INIT_BIT_SCOPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Verifier.Result.Status status;
    private @Nullable Verifier.Scope scope;
    private List<Verifier.VerifierError> errors = new ArrayList<Verifier.VerifierError>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Result} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Verifier.Result instance) {
      Objects.requireNonNull(instance, "instance");
      status(instance.getStatus());
      scope(instance.getScope());
      addAllErrors(instance.getErrors());
      return this;
    }

    /**
     * Initializes the value for the {@link Verifier.Result#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(Verifier.Result.Status status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Verifier.Result#getScope() scope} attribute.
     * @param scope The value for scope 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scope(Verifier.Scope scope) {
      this.scope = Objects.requireNonNull(scope, "scope");
      initBits &= ~INIT_BIT_SCOPE;
      return this;
    }

    /**
     * Adds one element to {@link Verifier.Result#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Verifier.VerifierError element) {
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link Verifier.Result#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Verifier.VerifierError... elements) {
      for (Verifier.VerifierError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Verifier.Result#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(Iterable<? extends Verifier.VerifierError> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Verifier.Result#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Verifier.VerifierError> elements) {
      for (Verifier.VerifierError element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableResult ImmutableResult}.
     * @return An immutable instance of Result
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableResult(status, scope, createUnmodifiableList(true, errors));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_SCOPE) != 0) attributes.add("scope");
      return "Cannot build Result, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
