package io.syndesis.verifier;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link Verifier.Error}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableError.builder()}.
 */
@SuppressWarnings({"all"})
@SuppressFBWarnings
@Generated({"Immutables.generator", "Verifier.Error"})
public final class ImmutableError implements Verifier.Error {
  private final String code;
  private final String description;
  private final List<String> parameters;
  private final Map<String, Object> attributes;

  private ImmutableError(
      String code,
      String description,
      List<String> parameters,
      Map<String, Object> attributes) {
    this.code = code;
    this.description = description;
    this.parameters = parameters;
    this.attributes = attributes;
  }

  /**
   * @return The value of the {@code code} attribute
   */
  @JsonProperty("code")
  @Override
  public String getCode() {
    return code;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public Optional<String> getDescription() {
    return Optional.ofNullable(description);
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @JsonProperty("parameters")
  @Override
  public List<String> getParameters() {
    return parameters;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @JsonProperty("attributes")
  @Override
  public Map<String, Object> getAttributes() {
    return attributes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Verifier.Error#getCode() code} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for code
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableError withCode(String value) {
    if (this.code.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "code");
    return new ImmutableError(newValue, this.description, this.parameters, this.attributes);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Verifier.Error#getDescription() description} attribute.
   * @param value The value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (Objects.equals(this.description, newValue)) return this;
    return new ImmutableError(this.code, newValue, this.parameters, this.attributes);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Verifier.Error#getDescription() description} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for description
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withDescription(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableError(this.code, value, this.parameters, this.attributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Verifier.Error#getParameters() parameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withParameters(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableError(this.code, this.description, newValue, this.attributes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Verifier.Error#getParameters() parameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of parameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withParameters(Iterable<String> elements) {
    if (this.parameters == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableError(this.code, this.description, newValue, this.attributes);
  }

  /**
   * Copy the current immutable object by replacing the {@link Verifier.Error#getAttributes() attributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the attributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableError withAttributes(Map<String, ? extends Object> entries) {
    if (this.attributes == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableError(this.code, this.description, this.parameters, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableError} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableError
        && equalTo((ImmutableError) another);
  }

  private boolean equalTo(ImmutableError another) {
    return code.equals(another.code)
        && Objects.equals(description, another.description)
        && parameters.equals(another.parameters)
        && attributes.equals(another.attributes);
  }

  /**
   * Computes a hash code from attributes: {@code code}, {@code description}, {@code parameters}, {@code attributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + code.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + parameters.hashCode();
    h += (h << 5) + attributes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Error} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Error{");
    builder.append("code=").append(code);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    builder.append(", ");
    builder.append("parameters=").append(parameters);
    builder.append(", ");
    builder.append("attributes=").append(attributes);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link Verifier.Error} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Error instance
   */
  public static ImmutableError copyOf(Verifier.Error instance) {
    if (instance instanceof ImmutableError) {
      return (ImmutableError) instance;
    }
    return ImmutableError.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableError ImmutableError}.
   * @return A new ImmutableError builder
   */
  public static ImmutableError.Builder builder() {
    return new ImmutableError.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableError ImmutableError}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CODE = 0x1L;
    private long initBits = 0x1L;

    private String code;
    private String description;
    private List<String> parameters = new ArrayList<String>();
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Error} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Verifier.Error instance) {
      Objects.requireNonNull(instance, "instance");
      code(instance.getCode());
      Optional<String> descriptionOptional = instance.getDescription();
      if (descriptionOptional.isPresent()) {
        description(descriptionOptional);
      }
      addAllParameters(instance.getParameters());
      putAllAttributes(instance.getAttributes());
      return this;
    }

    /**
     * Initializes the value for the {@link Verifier.Error#getCode() code} attribute.
     * @param code The value for code 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("code")
    public final Builder code(String code) {
      this.code = Objects.requireNonNull(code, "code");
      initBits &= ~INIT_BIT_CODE;
      return this;
    }

    /**
     * Initializes the optional value {@link Verifier.Error#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      return this;
    }

    /**
     * Initializes the optional value {@link Verifier.Error#getDescription() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(Optional<String> description) {
      this.description = description.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link Verifier.Error#getParameters() parameters} list.
     * @param element A parameters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(String element) {
      this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      return this;
    }

    /**
     * Adds elements to {@link Verifier.Error#getParameters() parameters} list.
     * @param elements An array of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addParameters(String... elements) {
      for (String element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link Verifier.Error#getParameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parameters")
    public final Builder parameters(Iterable<String> elements) {
      this.parameters.clear();
      return addAllParameters(elements);
    }

    /**
     * Adds elements to {@link Verifier.Error#getParameters() parameters} list.
     * @param elements An iterable of parameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllParameters(Iterable<String> elements) {
      for (String element : elements) {
        this.parameters.add(Objects.requireNonNull(element, "parameters element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link Verifier.Error#getAttributes() attributes} map.
     * @param key The key in the attributes map
     * @param value The associated value in the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(String key, Object value) {
      this.attributes.put(
          Objects.requireNonNull(key, "attributes key"),
          Objects.requireNonNull(value, "attributes value"));
      return this;
    }

    /**
     * Put one entry to the {@link Verifier.Error#getAttributes() attributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAttributes(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.attributes.put(
          Objects.requireNonNull(k, "attributes key"),
          Objects.requireNonNull(v, "attributes value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Verifier.Error#getAttributes() attributes} map. Nulls are not permitted
     * @param attributes The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributes")
    public final Builder attributes(Map<String, ? extends Object> attributes) {
      this.attributes.clear();
      return putAllAttributes(attributes);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Verifier.Error#getAttributes() attributes} map. Nulls are not permitted
     * @param attributes The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAttributes(Map<String, ? extends Object> attributes) {
      for (Map.Entry<String, ? extends Object> entry : attributes.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.attributes.put(
            Objects.requireNonNull(k, "attributes key"),
            Objects.requireNonNull(v, "attributes value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableError ImmutableError}.
     * @return An immutable instance of Error
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableError build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableError(
          code,
          description,
          createUnmodifiableList(true, parameters),
          createUnmodifiableMap(false, false, attributes));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CODE) != 0) attributes.add("code");
      return "Cannot build Error, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
