/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.project.generator.mvn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;

public final class MavenGav
implements Comparable<MavenGav> {
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
    private static final char SEPARATOR_COORDINATE = ':';
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_TYPE = "jar";
    private static final int IS_POS_1 = 1;
    private static final int ID_POS_2 = 2;
    private static final int ID_POS_3 = 4;
    private static final int ID_POS_4 = 6;
    private static final int ID_POS_5 = 8;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String type;
    private String classifier;

    public MavenGav(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = DEFAULT_TYPE;
        this.version = version;
        this.classifier = EMPTY_STRING;
    }

    public MavenGav(String coordinates) {
        Matcher m = DEPENDENCY_PATTERN.matcher(coordinates);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad artifact coordinates, expected format is <groupId>:<artifactId>[:<packagingType>[:<classifier>]]:(<version>|'?'), got: " + coordinates);
        }
        this.type = DEFAULT_TYPE;
        this.classifier = EMPTY_STRING;
        this.groupId = m.group(1);
        this.artifactId = m.group(2);
        String position3 = m.group(4);
        String position4 = m.group(6);
        String position5 = m.group(8);
        int noOfColons = MavenGav.numberOfOccurrences(coordinates, ':');
        switch (noOfColons) {
            case 2: {
                this.version = position3;
                break;
            }
            case 3: {
                this.type = position3 == null || position3.length() == 0 ? DEFAULT_TYPE : position3;
                this.version = position4;
                break;
            }
            default: {
                this.type = position3 == null || position3.length() == 0 ? DEFAULT_TYPE : position3;
                this.classifier = position4;
                this.version = position5;
            }
        }
    }

    public String getPackaging() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupId()).append(':').append(this.getArtifactId()).append(':').append(this.getPackaging());
        if (!StringUtils.isEmpty((CharSequence)this.getClassifier())) {
            sb.append(':').append(this.getClassifier());
        }
        sb.append(':').append(this.getVersion());
        return sb.toString();
    }

    public String toString() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGav gav = (MavenGav)o;
        if (this.groupId != null ? !this.groupId.equals(gav.groupId) : gav.groupId != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(gav.artifactId) : gav.artifactId != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(gav.type) : gav.type != null) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(gav.classifier) : gav.classifier != null) {
            return false;
        }
        return this.version != null ? this.version.equals(gav.version) : gav.version == null;
    }

    public int hashCode() {
        int result = this.groupId != null ? this.groupId.hashCode() : 0;
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(MavenGav o) {
        return new CompareToBuilder().append((Object)this.groupId, (Object)o.groupId).append((Object)this.artifactId, (Object)o.artifactId).append((Object)this.type, (Object)o.type).append((Object)this.classifier, (Object)o.classifier).append((Object)this.version, (Object)o.version).toComparison();
    }

    private static int numberOfOccurrences(CharSequence haystack, char needle) {
        int counter = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++counter;
        }
        return counter;
    }
}

