/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.integration.project.generator;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import io.syndesis.core.Json;
import io.syndesis.core.Names;
import io.syndesis.integration.api.IntegrationProjectGenerator;
import io.syndesis.integration.api.IntegrationResourceManager;
import io.syndesis.integration.project.generator.ProjectGeneratorConfiguration;
import io.syndesis.integration.project.generator.ProjectGeneratorHelper;
import io.syndesis.integration.project.generator.mvn.MavenGav;
import io.syndesis.integration.project.generator.mvn.PomContext;
import io.syndesis.model.Dependency;
import io.syndesis.model.integration.IntegrationDeployment;
import io.syndesis.model.integration.Step;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectGenerator
implements IntegrationProjectGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectGenerator.class);
    private final MustacheFactory mf = new DefaultMustacheFactory();
    private final ProjectGeneratorConfiguration generatorProperties;
    private final IntegrationResourceManager resourceManager;
    private final Mustache applicationJavaMustache;
    private final Mustache applicationPropertiesMustache;
    private final Mustache pomMustache;

    public ProjectGenerator(ProjectGeneratorConfiguration generatorProperties, IntegrationResourceManager resourceManager) throws IOException {
        this.generatorProperties = generatorProperties;
        this.resourceManager = resourceManager;
        this.applicationJavaMustache = this.compile(generatorProperties, "Application.java.mustache", "Application.java");
        this.applicationPropertiesMustache = this.compile(generatorProperties, "application.properties.mustache", "application.properties");
        this.pomMustache = this.compile(generatorProperties, "pom.xml.mustache", "pom.xml");
    }

    public InputStream generate(IntegrationDeployment deployment) throws IOException {
        PipedInputStream is = new PipedInputStream();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        PipedOutputStream os = new PipedOutputStream(is);
        executor.execute(this.generateAddProjectTarEntries(deployment, os));
        return is;
    }

    public byte[] generatePom(IntegrationDeployment deployment) throws IOException {
        Set dependencies = this.resourceManager.collectDependencies(deployment).stream().filter(Dependency::isMaven).map(Dependency::getId).map(MavenGav::new).filter(ProjectGeneratorHelper::filterDefaultDependencies).collect(Collectors.toCollection(TreeSet::new));
        return ProjectGeneratorHelper.generate(new PomContext(deployment.getId().orElse(""), deployment.getName(), deployment.getSpec().getDescription().orElse(null), dependencies, this.generatorProperties.getMavenProperties()), this.pomMustache);
    }

    private Mustache compile(ProjectGeneratorConfiguration generatorProperties, String template, String name) throws IOException {
        String overridePath = generatorProperties.getTemplates().getOverridePath();
        URL resource = null;
        if (!StringUtils.isEmpty((CharSequence)overridePath)) {
            resource = this.getClass().getResource("templates/" + overridePath + "/" + template);
        }
        if (resource == null) {
            resource = this.getClass().getResource("templates/" + template);
        }
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Unable to find te required template (overridePath=%s, template=%s)", overridePath, template));
        }
        try (InputStream stream = resource.openStream();){
            Mustache mustache = this.mf.compile((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), name);
            return mustache;
        }
    }

    private void addAdditionalResources(TarArchiveOutputStream tos) throws IOException {
        for (ProjectGeneratorConfiguration.Templates.Resource additionalResource : this.generatorProperties.getTemplates().getAdditionalResources()) {
            String overridePath = this.generatorProperties.getTemplates().getOverridePath();
            URL resource = null;
            if (!StringUtils.isEmpty((CharSequence)overridePath)) {
                resource = this.getClass().getResource("templates/" + overridePath + "/" + additionalResource.getSource());
            }
            if (resource == null) {
                resource = this.getClass().getResource("templates/" + additionalResource.getSource());
            }
            if (resource == null) {
                throw new IllegalArgumentException(String.format("Unable to find te required additional resource (overridePath=%s, source=%s)", overridePath, additionalResource.getSource()));
            }
            try {
                ProjectGeneratorHelper.addTarEntry(tos, additionalResource.getDestination(), Files.readAllBytes(Paths.get(resource.toURI())));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }

    private Runnable generateAddProjectTarEntries(IntegrationDeployment deployment, OutputStream os) {
        return () -> {
            block15: {
                try (TarArchiveOutputStream tos = new TarArchiveOutputStream(os);){
                    tos.setLongFileMode(3);
                    ProjectGeneratorHelper.addTarEntry(tos, "src/main/java/io/syndesis/example/Application.java", ProjectGeneratorHelper.generate(deployment, this.applicationJavaMustache));
                    ProjectGeneratorHelper.addTarEntry(tos, "src/main/resources/application.properties", ProjectGeneratorHelper.generate(deployment, this.applicationPropertiesMustache));
                    ProjectGeneratorHelper.addTarEntry(tos, "src/main/resources/syndesis/integration/integration.json", Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)deployment));
                    ProjectGeneratorHelper.addTarEntry(tos, "pom.xml", this.generatePom(deployment));
                    this.addResource(tos, ".s2i/bin/assemble", "s2i/assemble");
                    this.addExtensions(tos, deployment);
                    this.addAdditionalResources(tos);
                    for (Step step : deployment.getSpec().getSteps()) {
                        Map properties;
                        String mapping;
                        if (!"mapper".equals(step.getStepKind()) || (mapping = (String)(properties = step.getConfiguredProperties()).get("atlasmapping")) == null) continue;
                        String index = (String)step.getMetadata("step.index").orElseThrow(() -> new IllegalArgumentException("Missing index for step:" + step));
                        String resource = "mapping-step-" + index + ".json";
                        ProjectGeneratorHelper.addTarEntry(tos, "src/main/resources/" + resource, mapping.getBytes(StandardCharsets.UTF_8));
                    }
                    LOGGER.info("IntegrationDeployment [{}]: Project files written to output stream", (Object)Names.sanitize((String)deployment.getName()));
                }
                catch (IOException e) {
                    if (!LOGGER.isErrorEnabled()) break block15;
                    LOGGER.error(String.format("Exception while creating runtime build tar for deployment %s : %s", deployment.getName(), e.toString()), (Throwable)e);
                }
            }
        };
    }

    private void addResource(TarArchiveOutputStream tos, String destination, String resource) throws IOException {
        URL url = this.getClass().getResource(resource);
        byte[] bytes = IOUtils.toByteArray((URL)url);
        ProjectGeneratorHelper.addTarEntry(tos, destination, bytes);
    }

    private void addExtensions(TarArchiveOutputStream tos, IntegrationDeployment deployment) throws IOException {
        Set extensions = this.resourceManager.collectDependencies(deployment).stream().filter(Dependency::isExtension).map(Dependency::getId).collect(Collectors.toCollection(TreeSet::new));
        if (!extensions.isEmpty()) {
            ProjectGeneratorHelper.addTarEntry(tos, "src/main/resources/loader.properties", this.generateExtensionLoader(extensions));
            for (String extensionId : extensions) {
                ProjectGeneratorHelper.addTarEntry(tos, "extensions/" + Names.sanitize((String)extensionId) + ".jar", IOUtils.toByteArray((InputStream)((InputStream)this.resourceManager.loadExtensionBLOB(extensionId).orElseThrow(() -> new IllegalStateException("No extension blob for extension with id:" + extensionId)))));
            }
        }
    }

    private byte[] generateExtensionLoader(Set<String> extensions) {
        if (!extensions.isEmpty()) {
            return ("loader.path" + '=' + extensions.stream().map(Names::sanitize).map(id -> this.generatorProperties.getSyndesisExtensionPath() + "/" + id + ".jar").collect(Collectors.joining(",")) + '\n').getBytes(StandardCharsets.UTF_8);
        }
        return new byte[0];
    }
}

