/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import io.strmprivacy.driver.serializer.AvroSerializer;
import io.strmprivacy.driver.serializer.EventSerializer;
import io.strmprivacy.driver.serializer.JsonSerializer;
import io.strmprivacy.driver.serializer.UnsupportedSerializationTypeException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;

public class SerializerProvider {
    private static final Map<String, EventSerializer> serializers = new HashMap<String, EventSerializer>();

    private SerializerProvider() {
    }

    public static EventSerializer getSerializer(String schemaId_, Object schema) {
        return serializers.computeIfAbsent(schemaId_, schemaId -> {
            if (schema instanceof Schema) {
                return new AvroSerializer((Schema)schema);
            }
            if (schema instanceof JsonNode) {
                return new JsonSerializer((JsonNode)schema);
            }
            throw new UnsupportedSerializationTypeException("Provided serialization type is not supported");
        });
    }
}

