/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.strmprivacy.driver.client.AuthProvider;
import io.strmprivacy.driver.domain.Config;
import io.strmprivacy.driver.domain.StrmPrivacyException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringRequestContent;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthService {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private final String clientId;
    private final String clientSecret;
    private final HttpClient httpClient;
    private final CountDownLatch latch;
    private final Timer timer;
    private AuthProvider authProvider;
    private final String authUri;
    private final String refreshUri;

    public AuthService(String clientId, String clientSecret, Config config) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.httpClient = new HttpClient();
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("An unexpected error occurred while starting a new AuthService for STRM Privacy.", e);
        }
        try {
            this.authUri = new URI(String.format("%s://%s%s", config.getAuthScheme(), config.getAuthHost(), config.getAuthEndpoint())).toString();
            this.refreshUri = new URI(String.format("%s://%s%s", config.getAuthScheme(), config.getAuthHost(), config.getAuthEndpoint())).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Malformed URI(s) for " + this.getClass().getCanonicalName(), e);
        }
        this.timer = new Timer();
        this.latch = new CountDownLatch(1);
        this.timer.schedule((TimerTask)new AuthProviderInitializerTask(), 0L, Duration.ofMinutes(5L).toMillis());
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Error while setting up authentication for STRM Privacy", e);
        }
    }

    public String getAccessToken() {
        return this.authProvider.getAccessToken();
    }

    public void stop() {
        try {
            this.timer.cancel();
            this.httpClient.stop();
        }
        catch (Exception e) {
            throw new StrmPrivacyException("Error stopping AuthService HttpClient", e);
        }
    }

    private void authenticate(String clientId, String clientSecret) {
        try {
            String payload = String.format("grant_type=client_credentials&client_id=%s&client_secret=%s", clientId, clientSecret);
            this.doPost(this.authUri, payload);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            log.error("An error occurred while requesting an access token with clientId '{}'", (Object)clientId, (Object)e);
        }
    }

    private void refresh(String refreshToken, String clientId, String clientSecret) {
        try {
            String payload = String.format("grant_type=refresh_token&client_id=%s&client_secret=%s&refresh_token=%s", clientId, clientSecret, refreshToken);
            this.doPost(this.refreshUri, payload);
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
            log.debug("Failed to refresh token with clientId '{}'", (Object)clientId);
            log.debug("Trying to request a new token with clientId '{}'", (Object)clientId);
            this.authenticate(clientId, clientSecret);
        }
    }

    private void doPost(String uri, String payload) throws IOException, InterruptedException, TimeoutException, ExecutionException {
        ContentResponse response = this.httpClient.POST(uri).headers(headers -> headers.add(HttpHeader.CONTENT_TYPE, "application/x-www-form-urlencoded")).body((Request.Content)new StringRequestContent(payload)).send();
        this.authProvider = (AuthProvider)MAPPER.readValue(response.getContentAsString(), AuthProvider.class);
        this.authProvider.setExpiresAt();
    }

    private class AuthProviderInitializerTask
    extends TimerTask {
        private final long expirationSlackTimeSeconds = Duration.ofMinutes(10L).getSeconds();

        private AuthProviderInitializerTask() {
        }

        @Override
        public void run() {
            if (AuthService.this.authProvider == null) {
                log.debug("Initializing a new Auth Provider");
                AuthService.this.authenticate(AuthService.this.clientId, AuthService.this.clientSecret);
                AuthService.this.latch.countDown();
            } else if (this.isAlmostExpired(AuthService.this.authProvider.getExpiresAt())) {
                log.debug("Refreshing an existing Auth Provider");
                AuthService.this.refresh(AuthService.this.authProvider.getRefreshToken(), AuthService.this.clientId, AuthService.this.clientSecret);
            }
        }

        private boolean isAlmostExpired(long expirationTime) {
            long currentTime = Instant.now().getEpochSecond();
            return currentTime + this.expirationSlackTimeSeconds >= expirationTime;
        }
    }
}

