/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.domain;

public class Config {
    private String gatewayScheme;
    private String gatewayHost;
    private String gatewayEndpoint;
    private int gatewayPort;
    private String authScheme;
    private String authHost;
    private String authEndpoint;

    private Config(Builder builder) {
        this.setGatewayScheme(builder.gatewayScheme);
        this.setGatewayHost(builder.gatewayHost);
        this.setGatewayEndpoint(builder.gatewayEndpoint);
        this.setGatewayPort(builder.gatewayPort);
        this.setAuthScheme(builder.authScheme);
        this.setAuthHost(builder.authHost);
        this.setAuthEndpoint(builder.authEndpoint);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getImplementationVersion() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return version != null ? version : "development";
    }

    public String getGatewayScheme() {
        return this.gatewayScheme;
    }

    public void setGatewayScheme(String gatewayScheme) {
        this.gatewayScheme = gatewayScheme;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public String getGatewayEndpoint() {
        return this.gatewayEndpoint;
    }

    public void setGatewayEndpoint(String gatewayEndpoint) {
        this.gatewayEndpoint = gatewayEndpoint;
    }

    public int getGatewayPort() {
        return this.gatewayPort;
    }

    public void setGatewayPort(int gatewayPort) {
        this.gatewayPort = gatewayPort;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthHost(String authHost) {
        this.authHost = authHost;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public void setAuthEndpoint(String authEndpoint) {
        this.authEndpoint = authEndpoint;
    }

    public String getAuthEndpoint() {
        return this.authEndpoint;
    }

    public static final class Builder {
        private String gatewayScheme = "https";
        private String gatewayHost = "events.strmprivacy.io";
        private String gatewayEndpoint = "/event";
        private int gatewayPort = 443;
        private String authScheme = "https";
        private String authHost = "accounts.strmprivacy.io";
        private String authEndpoint = "/auth/realms/streams/protocol/openid-connect/token";

        private Builder() {
        }

        public Builder gatewayScheme(String val) {
            this.gatewayScheme = val;
            return this;
        }

        public Builder gatewayHost(String val) {
            this.gatewayHost = val;
            return this;
        }

        public Builder gatewayPort(int val) {
            this.gatewayPort = val;
            return this;
        }

        public Builder gatewayEndpoint(String val) {
            this.gatewayEndpoint = val;
            return this;
        }

        public Builder authScheme(String val) {
            this.authScheme = val;
            return this;
        }

        public Builder authHost(String val) {
            this.authHost = val;
            return this;
        }

        public Builder authEndpoint(String val) {
            this.authEndpoint = val;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }
}

