/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.client;

import io.strmprivacy.driver.client.AuthService;
import io.strmprivacy.driver.client.SenderService;
import io.strmprivacy.driver.domain.Config;
import io.strmprivacy.schemas.StrmPrivacyEvent;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.api.ContentResponse;

public class StrmPrivacyClient {
    private final AuthService authService;
    private final SenderService senderService;

    public StrmPrivacyClient(String clientId, String clientSecret, Config config) {
        this.authService = new AuthService(clientId, clientSecret, config);
        this.senderService = new SenderService(this.authService, config);
    }

    private StrmPrivacyClient(Builder builder) {
        this(builder.clientId, builder.clientSecret, builder.config);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public CompletableFuture<ContentResponse> send(StrmPrivacyEvent event, Object serializationType) {
        return this.send(event);
    }

    public CompletableFuture<ContentResponse> send(StrmPrivacyEvent event) {
        return this.senderService.send(event);
    }

    public void stop() {
        this.senderService.stop();
        this.authService.stop();
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private Config config;

        private Builder() {
        }

        public StrmPrivacyClient build() {
            return new StrmPrivacyClient(this);
        }

        public Builder clientId(String val) {
            this.clientId = val;
            return this;
        }

        public Builder clientSecret(String val) {
            this.clientSecret = val;
            return this;
        }

        public Builder config(Config val) {
            this.config = val;
            return this;
        }
    }
}

