/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.serializer;

import io.strmprivacy.driver.serializer.EventSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;

public class AvroSerializer
implements EventSerializer {
    private DatumWriter<GenericRecord> writer;

    public AvroSerializer(Schema writerSchema) {
        this.writer = new SpecificDatumWriter(writerSchema);
    }

    @Override
    public byte[] serialize(Object event) throws IllegalStateException, IOException {
        if (!(event instanceof GenericRecord)) {
            throw new IllegalArgumentException("Event is not of type GenericRecord");
        }
        GenericRecord msg = (GenericRecord)event;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        this.writer.write((Object)msg, (Encoder)encoder);
        encoder.flush();
        return baos.toByteArray();
    }

    public void tearDown() {
        this.writer = null;
    }
}

