/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import io.strmprivacy.driver.serializer.EventSerializer;
import io.strmprivacy.driver.serializer.SerializationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements EventSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JsonNode schema;

    public JsonSerializer(JsonNode schema) {
        this.schema = schema;
    }

    @Override
    public byte[] serialize(Object event, SerializationType serializationType) {
        JsonNode node = (JsonNode)MAPPER.convertValue(event, JsonNode.class);
        JsonValidator jsonValidator = JsonSchemaFactory.byDefault().getValidator();
        try {
            ProcessingReport report = jsonValidator.validate(this.schema, node);
            if (report.isSuccess()) {
                return MAPPER.writeValueAsBytes(event);
            }
            IllegalArgumentException validationException = new IllegalArgumentException("Provided JSON event does not match with schema");
            report.iterator().forEachRemaining(message -> validationException.addSuppressed(message.asException()));
            throw validationException;
        }
        catch (JsonProcessingException e) {
            log.error("Error while converting provided event to bytes", (Throwable)e);
        }
        catch (ProcessingException e) {
            log.error("Error while validating provided event against schema", (Throwable)e);
        }
        return new byte[0];
    }
}

