/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.serializer;

import io.strmprivacy.driver.serializer.EventSerializer;
import io.strmprivacy.driver.serializer.SerializationType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer
implements EventSerializer {
    private static final Logger log = LoggerFactory.getLogger(AvroSerializer.class);
    private final Schema writerSchema;
    private DatumWriter<GenericRecord> writer;

    public AvroSerializer(Schema writerSchema) {
        this.writerSchema = writerSchema;
        this.writer = new SpecificDatumWriter(writerSchema);
    }

    @Override
    public byte[] serialize(Object event, SerializationType serializationType) throws IllegalStateException, IOException {
        if (!(event instanceof GenericRecord)) {
            throw new IllegalArgumentException("Event is not of type GenericRecord");
        }
        GenericRecord msg = (GenericRecord)event;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switch (serializationType) {
            case AVRO_BINARY: {
                BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
                this.writer.write((Object)msg, (Encoder)encoder);
                encoder.flush();
                break;
            }
            case AVRO_JSON: {
                GenericDatumWriter jsonWriter = new GenericDatumWriter(this.writerSchema);
                JsonEncoder encoder = EncoderFactory.get().jsonEncoder(this.writerSchema, (OutputStream)baos);
                jsonWriter.write((Object)msg, (Encoder)encoder);
                encoder.flush();
            }
        }
        baos.flush();
        return baos.toByteArray();
    }

    public void tearDown() {
        this.writer = null;
    }
}

