/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.domain;

import io.strmprivacy.driver.serializer.EventSerializer;
import io.strmprivacy.driver.serializer.SerializationType;
import io.strmprivacy.driver.serializer.SerializerProvider;
import io.strmprivacy.driver.serializer.UnsupportedSerializationTypeException;
import io.strmprivacy.schemas.StrmPrivacyEvent;
import java.io.IOException;

public class StrmPrivacyEventDTO {
    private final StrmPrivacyEvent event;
    private final SerializationType serializationType;

    public StrmPrivacyEventDTO(StrmPrivacyEvent event, SerializationType serializationType) {
        this.event = event;
        this.serializationType = serializationType;
    }

    public String getSchemaRef() {
        return this.event.getSchemaRef();
    }

    public String getSerializationTypeHeader() {
        switch (this.serializationType) {
            case JSON: 
            case AVRO_JSON: {
                return "application/json";
            }
            case AVRO_BINARY: {
                return "application/x-avro-binary";
            }
        }
        throw new UnsupportedSerializationTypeException("Unsupported Serialization Type '" + (Object)((Object)this.serializationType) + "'.");
    }

    public byte[] serialize() {
        try {
            Object StrmPrivacyEventSchema = this.event.getSchema();
            EventSerializer serializer = SerializerProvider.getSerializer(this.getSchemaRef(), StrmPrivacyEventSchema);
            return serializer.serialize(this.event, this.serializationType);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StrmPrivacyEventDTOBuilder builder() {
        return new StrmPrivacyEventDTOBuilder();
    }

    public StrmPrivacyEvent getEvent() {
        return this.event;
    }

    public SerializationType getSerializationType() {
        return this.serializationType;
    }

    public static class StrmPrivacyEventDTOBuilder {
        private StrmPrivacyEvent event;
        private SerializationType serializationType;

        StrmPrivacyEventDTOBuilder() {
        }

        public StrmPrivacyEventDTOBuilder event(StrmPrivacyEvent event) {
            this.event = event;
            return this;
        }

        public StrmPrivacyEventDTOBuilder serializationType(SerializationType serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        public StrmPrivacyEventDTO build() {
            return new StrmPrivacyEventDTO(this.event, this.serializationType);
        }

        public String toString() {
            return "StrmPrivacyEventDTO.StrmPrivacyEventDTOBuilder(event=" + this.event + ", serializationType=" + (Object)((Object)this.serializationType) + ")";
        }
    }
}

