/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.driver.client;

import io.strmprivacy.driver.client.AuthService;
import io.strmprivacy.driver.client.ReceiverService;
import io.strmprivacy.driver.client.SenderService;
import io.strmprivacy.driver.common.WebSocketConsumer;
import io.strmprivacy.driver.domain.Config;
import io.strmprivacy.driver.serializer.SerializationType;
import io.strmprivacy.schemas.StrmPrivacyEvent;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrmPrivacyClient {
    private static final Logger log = LoggerFactory.getLogger(StrmPrivacyClient.class);
    private final AuthService authService;
    private final SenderService senderService;
    private final ReceiverService receiverService;

    public StrmPrivacyClient(String billingId, String clientId, String clientSecret, Config config) {
        this.authService = new AuthService(billingId, clientId, clientSecret, config);
        this.senderService = new SenderService(this.authService, config);
        this.receiverService = new ReceiverService(this.authService, config);
    }

    public CompletableFuture<ContentResponse> send(StrmPrivacyEvent event, SerializationType type) {
        return this.senderService.send(event, type);
    }

    public void startReceivingWs(boolean asJson, WebSocketConsumer consumer) {
        this.receiverService.receiveWs(asJson, consumer);
    }

    public ContentResponse egressIsAlive() {
        return this.receiverService.isAlive();
    }

    public void stop() {
        this.senderService.stop();
        this.receiverService.stop();
        this.authService.stop();
    }

    public static StrmPrivacyClientBuilder builder() {
        return new StrmPrivacyClientBuilder();
    }

    public static class StrmPrivacyClientBuilder {
        private String billingId;
        private String clientId;
        private String clientSecret;
        private Config config;

        StrmPrivacyClientBuilder() {
        }

        public StrmPrivacyClientBuilder billingId(String billingId) {
            this.billingId = billingId;
            return this;
        }

        public StrmPrivacyClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public StrmPrivacyClientBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public StrmPrivacyClientBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public StrmPrivacyClient build() {
            return new StrmPrivacyClient(this.billingId, this.clientId, this.clientSecret, this.config);
        }

        public String toString() {
            return "StrmPrivacyClient.StrmPrivacyClientBuilder(billingId=" + this.billingId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", config=" + this.config + ")";
        }
    }
}

