/*
 * Decompiled with CFR 0.152.
 */
package io.strmprivacy.aws.lambda.decrypter;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.JsonKeysetReader;
import com.google.crypto.tink.KeysetReader;
import com.google.crypto.tink.daead.DeterministicAeadConfig;
import io.strmprivacy.aws.lambda.decrypter.BadCipherText;
import io.strmprivacy.aws.lambda.decrypter.BadEncryptionKey;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0005RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/strmprivacy/aws/lambda/decrypter/Decrypt;", "", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lcom/google/crypto/tink/DeterministicAead;", "decoder", "Ljava/util/Base64$Decoder;", "decrypt", "encryptionKey", "cipherText", "deterministicAead", "lib"})
public final class Decrypt {
    @NotNull
    public static final Decrypt INSTANCE = new Decrypt();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private static final Cache<String, DeterministicAead> cache = Caffeine.newBuilder().maximumSize(10000L).build();

    private Decrypt() {
    }

    @Nullable
    public final String decrypt(@NotNull String encryptionKey, @Nullable String cipherText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        if (cipherText == null) {
            return null;
        }
        DeterministicAead daead = (DeterministicAead)cache.get((Object)encryptionKey, Decrypt::decrypt$lambda-0);
        try {
            DeterministicAead deterministicAead = daead;
            Intrinsics.checkNotNull((Object)deterministicAead);
            byte[] byArray = decoder.decode(cipherText);
            object = "";
            byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            object = deterministicAead.decryptDeterministically(byArray, byArray2);
        }
        catch (IllegalArgumentException e) {
            throw new BadCipherText(e);
        }
        catch (GeneralSecurityException e) {
            throw new BadCipherText(e);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"try {\n            daead!\u2026adCipherText(e)\n        }");
        return StringsKt.decodeToString((byte[])object2);
    }

    @Nullable
    public final DeterministicAead deterministicAead(@NotNull String encryptionKey) {
        DeterministicAead deterministicAead;
        Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
        try {
            deterministicAead = (DeterministicAead)CleartextKeysetHandle.read((KeysetReader)((KeysetReader)JsonKeysetReader.withString((String)encryptionKey))).getPrimitive(DeterministicAead.class);
        }
        catch (GeneralSecurityException e) {
            throw new BadEncryptionKey(e);
        }
        catch (IOException e) {
            throw new BadEncryptionKey(e);
        }
        return deterministicAead;
    }

    private static final DeterministicAead decrypt$lambda-0(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return INSTANCE.deterministicAead(it);
    }

    static {
        try {
            DeterministicAeadConfig.register();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            System.exit(10);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

